/* (c) KDDI Technology
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"

DigitalOut led1(LED1,"led1");
DigitalOut led2(LED2,"led2");
DigitalOut led3(LED3,"led3");
DigitalOut led4(LED4,"led4");

#if 1
/*
 * Use DHCP
 */
        EthernetNetIf ethif;
#else
/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
        EthernetNetIf ethif(IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx));
#endif
    
    HTTPServer server;
    LocalFileSystem local("local");

    /* RFC Interface */
    // inputデータに従い、LED1~4の点灯・消灯を設定する。inputデータはカンマ区切りを想定。
    void doSetLed(char* input, char* output);
    //RPC Interfaceを宣言(setLed:外部IF公開名、doSetLed:外部からのコール後、処理する関数名)
    RPCFunction test(&doSetLed, "setLed");
    // LEDの点灯・消灯情報を取得可能な外部IF
    void doGetLed(char* input, char* output);
    RPCFunction getdata(&doGetLed, "getLed");

    /* locan func */
    void _createOutputString(char* output);

int main(void) {

    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    
    wait(1);
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    while (1) {
        Net::poll();
    }
}

// Led1-4の点灯・消灯処理
void doSetLed(char* input, char* output) {

  char *tok;
  char s2[] = ",";  /* カンマで区切られていることを想定 */
  int cnt = 1;
  tok = strtok( input, "," );
  
  // カンマ区切りの文字列を取得し、1:LED点灯、0(1以外):消灯とする
  while( tok != NULL ){
    int ret;
    int setled = 0;
    ret = strcmp( tok, "1" );
    if (ret == 0) {
      setled = 1;
    } else {
      setled = 0;
    }
    switch (cnt) {
      case 1:
          led1 = setled;
          break;
      case 2:
          led2 = setled;
          break;
      case 3:
          led3 = setled;
          break;
      case 4:
          led4 = setled;
          break;
      default:
          break;          
    }
    cnt++;
    tok = strtok( NULL, s2 );  /* 2回目以降 */
  }

  // 完了時には文字列"finish"を返却する
  _createOutputString(output);
}

// LEDの点灯情報をJSONデータで返却する
void doGetLed(char* input, char* output) {

  _createOutputString(output);
}

// outputにJSON形式の文字列を設定する
void _createOutputString(char* output) {

  sprintf(output, "{\"led1\":%d, \"led2\":%d, \"led3\":%d, \"led4\":%d}",(int)led1, (int)led2, (int)led3, (int)led4);
}