/* (c) KDDI Technology
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "TextLCD.h"
#define TEXTLCD_LEN 16
#if 1
/*
 * Use DHCP
 */
        EthernetNetIf ethif;
#else
/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
        EthernetNetIf ethif(IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx));
#endif

    TextLCD lcd(p24, p26, p27, p28, p29, p30); //LCD
    
    HTTPServer server;
    LocalFileSystem local("local");

    // LCDディスプレイに文字列を表示させる
    void doSetLcd(char* input, char* output);
    // RPC Interfaceを宣言(setLcd:外部IF公開名、doSetLcd:外部からのコール後、処理する関数名)
    RPCFunction test(&doSetLcd, "setLcd");

int main(void) {

    lcd.locate(0,0);
    // LCD上段に以下を記載する
    lcd.printf("Program start..");

    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }

    // IPアドレスを取得
    IpAddr ethIp=ethif.getIp();
    // デフォルトはLCD下段にIPアドレスを表示
    lcd.locate(0,1);
    lcd.printf("%d.%d.%d.%d", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);

    wait(1);
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    while (1) {
        Net::poll();
    }
}

// LCDの下段にinputされた文字列を表示する
void doSetLcd(char* input, char* output) {

  lcd.locate(0,1);
  // 2行目を全て空白表示とする
  for (int i = 0; i < TEXTLCD_LEN; i++){
    lcd.printf(" ");
  }

  if (TEXTLCD_LEN < strlen(input)) {
    // inputデータが16文字を越える場合には、
    // LCD下段に一律"bad data"表示し、クライアント側に"fail"を返却する
    lcd.locate(0,1);
    lcd.printf("bad data");
    sprintf(output, "fail");
  } else {
    // inputデータが16文字以下の場合には、
    // LCD下段に表示し、クライアント側に"success"を返却する
    lcd.locate(0,1);
    lcd.printf("%s",input);
    sprintf(output, "success");
  }
}
