/* (c) KDDI Technology
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"

AnalogIn gyro1_adc(p16);// ジャイロ(角速度)1
AnalogIn gyro2_adc(p17);// ジャイロ(角速度)2

#if 1
/*
 * Use DHCP
 */
        EthernetNetIf ethif;
#else
/*
 * Use "static IP address" (Parameters:IP, Subnet mask, Gateway, DNS)
 */
        EthernetNetIf ethif(IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx), IpAddr(xxx,xxx,xxx,xxx));
#endif
    
    HTTPServer server;
    LocalFileSystem local("local");

    // 角速度(ジャイロ)情報を返却する
    void doGetGyro(char* input, char* output);
    // RPC Interfaceを宣言(getGyro:外部IF公開名、doGetGyro:外部からのコール後、処理する関数名)
    RPCFunction test(&doGetGyro, "getGyro");

int main(void) {

    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    
    wait(1);
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    while (1) {
        Net::poll();
    }
}

// 角速度(ジャイロ)情報を返却する
void doGetGyro(char* input, char* output) {

  float gy1_data;
  float gy2_data;
  gy1_data=gyro1_adc.read(); // ジャイロ1データの読み込み
  gy2_data=gyro2_adc.read(); // ジャイロ1データの読み込み
  
  // ジャイロセンサーから取得した値をoutputに対して文字列として設定し、
  // クライアント側に返却する。
  sprintf(output, "Gyro1:%2.5f, Gyro2:%2.5f",gy1_data ,gy2_data);
}
