#include "RPCObject.h"
#include "parse_pins.h"
#include "mbed.h"
#include "HTTPServer.h"


RPCObject::RPCObject()
{
}


int RPCObject::decode(char* request, char* reply)
{
   char* clz = strtok(request+1,"/");
   char* pin = strtok(NULL, "/");
   char* val = strtok(NULL, "/");   

    if(!strcmp(clz, "DigitalIn")){
        type = RPC_PIN_DIGITAL_IN;
        printf(" type is DigitalIn. \r\n");
    } else if(!strcmp(clz, "DigitalOut")){
        type = RPC_PIN_DIGITAL_OUT;
        printf(" type is DigitalOut. \r\n");
    } else if(!strcmp(clz, "DigitalInOut")){
        type = RPC_PIN_DIGITAL_INOUT;
        printf(" type is DigitalInOut. \r\n");
    } else {
        type = RPC_PIN_UNKNOWN;
        printf("Unsupported type name: %s. \r\n", clz);
        sprintf(reply, "Unsupported type name: %s. \r\n", clz);
        return HTTP_400_BADREQUEST;
    }
   
    pin_name = parse_pins(pin);
    if(pin_name == NC){
        printf("Unsupported pin name: %s. \n", pin);
        sprintf(reply, "Unsupported pin name: %s. \r\n", pin);
        return HTTP_400_BADREQUEST;
    }
    
    if(!val || val[0] == '\0'){
        value = -1;
    }
    else if(!strcmp(val, "delete")){
        value = -2;
    }    
    else {
        value = (val[0] - '0') ? 1 : 0;
    }
    
    return 0;
}


bool RPCObject::create_pin_object(char* reply) 
{
    RPCClass* pinobj;
    
    if(pinObjects.find(pin_name) != pinObjects.end()){
        printf("The pin already exists.\r\n");
        strcat(reply, "The pin already exists. ");
        return false;
    }
    
    switch(type){
    case RPC_PIN_DIGITAL_IN:
        printf("DigitalIn.\r\n");
        pinobj = new RPCDigitalIn(pin_name);
        break; 
    case RPC_PIN_DIGITAL_OUT:
        printf("DigitalOut.\r\n");
        pinobj = new RPCDigitalOut(pin_name);
        break;
    case RPC_PIN_DIGITAL_INOUT:
        printf("DigitalInOut.\r\n");
        pinobj = new RPCDigitalInOut(pin_name);
        break;
    default:
        printf(" Unsupported type.\r\n");
        strcat(reply, "Unsupported type. ");
        return false;
    }
    
    pinObjects[pin_name] = pinobj;   
    
    return true;
}
