#ifndef HTTP_SERVER
#define HTTP_SERVER

#include <map>
#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "TCPSocketServer.h"
#include "TCPSocketConnection.h"
#include "RequestHandler.h"
#include "RPCObject.h"

#define HTTP_REPLY_MAX_STRING 1024

enum
{
    HTTP_200_OK         = 200,
    HTTP_400_BADREQUEST = 400,
    HTTP_404_NOTFOUND   = 404
};


class HTTPServer
{
    public :
        HTTPServer();
        virtual ~HTTPServer();
        bool init(int port);
        void run();
        void add_request_handler(char *name, RequestHandler* handler);
        
    private :
        void handle_request(char* buffer);
        void create_response(char* buffer);
        TCPSocketServer socketserver;
        std::map<char*, RequestHandler*, bool(*)(char*, char*)> handlers;
        RPCObject object;
        char reply[HTTP_REPLY_MAX_STRING];
        int response_code;
};

#endif

