#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "HTTPServer.h"

/**
 * Wifi AP parameter
 */

/* Set this */ 
#define WIFI_SSID           ""
#define WIFI_SECUTIRY_KEY   ""
//#define WIFI_SECURITY_TYPE  e_SEC_OPEN
//#define WIFI_SECURITY_TYPE  e_SEC_WEP
//#define WIFI_SECURITY_TYPE  e_SEC_WPA_TKIP
#define WIFI_SECURITY_TYPE  e_SEC_WPA2_AES
//#define WIFI_SECURITY_TYPE  e_SEC_WPA2_MIXED
//#define WIFI_SECURITY_TYPE  e_SEC_WPA_AES


#define IP_ADDRESS      "192.168.0.44"
#define NET_MASK        "255.255.255.0"
#define DEFAULT_GATEWAY "192.168.0.1"
#define PORT_NUMBER     80


Serial pc(USBTX, USBRX);    // This is required when defined "_DEBUG"
/** Wi-Fi SNIC UART Interface*/
C_SNIC_WifiInterface     mSNICwifi( p13, p14, p12, p11, p20 );




void wifi_connect()
{
    // Initialize Wi-Fi interface
    if(mSNICwifi.init()!=0){
        printf("Wi-Fi initial failed\r\n");
        mbed_die();
    }
    wait(0.5);
    
    if(mSNICwifi.disconnect()!= 0 )
    {
        printf("on the disconnect state\r\n");
        mbed_die();
    } 
    wait(0.3);

    // Connect to AP
    if(mSNICwifi.connect( WIFI_SSID,strlen(WIFI_SSID), 
                          WIFI_SECURITY_TYPE, 
                          WIFI_SECUTIRY_KEY, 
                          strlen(WIFI_SECUTIRY_KEY))!=0)
    {
        printf("Connect AP is failed\r\n");
        mbed_die();
    }
    wait(0.5);
    
    int retIp = mSNICwifi.setIPConfig(false, IP_ADDRESS, NET_MASK, DEFAULT_GATEWAY);
}


int main()
{
    // for debug
    pc.baud( 115200 );

    wifi_connect();
    
    HTTPServer srv;
    
    pc.printf("server init.\r\n");
    srv.init(PORT_NUMBER);
    
    srv.add_request_handler("GET",    new GetRequestHandler());
    srv.add_request_handler("DELETE", new DeleteRequestHandler());
    srv.add_request_handler("POST",   new PostRequestHandler());
    
    wait(1);
    pc.printf("server running.\r\n");
    srv.run();
}
