#include "mbed.h"
#include "RequestHandler.h"
#include "RPCObject.h"
#include "HTTPServer.h"


int GetRequestHandler::handle(RPCObject& cmd, char* reply)
{
    int value;
    std::map<PinName, RPCClass*>::iterator itor;
    
    printf("handling GET request.\r\n");
    itor = cmd.pinObjects.find(cmd.get_pin_name());
    if(itor == cmd.pinObjects.end()){
        printf("The pin is not created.\r\n");
        return HTTP_404_NOTFOUND;
    }
    value = itor->second->read();
    
    reply[0] = '0' + value;
    reply[1] = '\0';
    
    return HTTP_200_OK;
}


int  PostRequestHandler::handle(RPCObject& cmd, char* reply)
{
    int value = cmd.get_value();
    std::map<PinName, RPCClass*>::iterator itor;
    
    printf("handling POST request.\r\n");
    switch(value){
    case 0:
    case 1:
         //update
        printf("now updating the object to %d.\r\n", value);
        itor = cmd.pinObjects.find(cmd.get_pin_name());
        if(itor == cmd.pinObjects.end()){
            printf("The pin is not created.\r\n");
            return HTTP_404_NOTFOUND;
        }
        itor->second->write(value);
        break;
    case -1:
        //create
        printf("now createing the object.\r\n");
        if(!cmd.create_pin_object(reply)){
            return -1;
        }
        break;
    case -2:
        // delete
        itor = cmd.pinObjects.find(cmd.get_pin_name());
        if(itor == cmd.pinObjects.end()){
            printf("The pin is not created.\r\n");
            return HTTP_404_NOTFOUND;
        }
        delete itor->second;
        cmd.pinObjects.erase(cmd.pinObjects.find(cmd.get_pin_name()));
        break;
    default:
        return -1;
    }
    
    return HTTP_200_OK;
}


int DeleteRequestHandler::handle(RPCObject& cmd, char* reply)
{   
    std::map<PinName, RPCClass*>::iterator itor;
    
    printf("handling DELETE request.\r\n");
    itor = cmd.pinObjects.find(cmd.get_pin_name());
    if(itor == cmd.pinObjects.end()){
        printf("The pin is not created.\r\n");
        return HTTP_404_NOTFOUND;
    }
    delete itor->second;
    cmd.pinObjects.erase(cmd.pinObjects.find(cmd.get_pin_name()));
    
    return HTTP_200_OK;
}


