#include "mbed.h"

#include "SNIC_WifiInterface.h"
// KTEC DEL S
//#include "HTTPClient.h"
// KTEC DEL E
#if defined(TARGET_LPC1768)
#include "PowerControl/EthernetPowerControl.h"
#endif
// KTEC ADD S
#include "Websocket.h"
#include "Websocket_Function.h"
// KTEC ADD E

#define DEMO_AP_SSID                  "SSID"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_AES
#define DEMO_AP_SECUTIRY_KEY          "PASSWORD"

C_SNIC_WifiInterface     wifi( p9, p10, NC, NC, p30 );

#if defined(_DEBUG)
Serial pc(USBTX, USBRX);
#endif

// KTEC DEL S
/*
HTTPClient http;
char str[512];
*/
// KTEC DEL E

// KTEC ADD S
// Websocketサーバ設定
// 送信チャネルと受信チャネルは違うチャンネル名、かつ、ユニークな値を設定してください。
// 送信チャネル名
#define WRITE_CHANNEL ""
// 受信チャネル名
#define READ_CHANNEL ""

Websocket *ws_write = NULL;
Websocket *ws_read = NULL;

Mutex socket_mutex; 
// KTEC ADD E

// KTEC ADD S
// Wifiモジュールに接続
int wifi_connect()
{
    int ret = 0;
    
    // Initialize Wi-Fi interface
    ret = wifi.init();
    if(ret != 0){
        printf("Wi-Fi initial failed %d\r\n", ret);
        return ret;
    }
    wait(0.5);

    ret = wifi.disconnect();
    if(ret != 0 )
    {
        printf("on the disconnect state %d\r\n", ret);
        return ret;
    } 
    wait(0.3);

    // Connect to AP
    ret = wifi.connect( DEMO_AP_SSID,strlen(DEMO_AP_SSID), 
                          DEMO_AP_SECURITY_TYPE, 
                          DEMO_AP_SECUTIRY_KEY, 
                          strlen(DEMO_AP_SECUTIRY_KEY));
    if(ret !=0)
    {
        printf("Connect AP is failed %d\r\n", ret);
        return ret;
    }
    wait(0.5);
    
    // DHCPでIPアドレスを取得
    int retIp = wifi.setIPConfig(true);
    wait(0.5);
    printf("IP Address is %s\r\n", wifi.getIPAddress());

    return ret;
}

// Websocketサーバ(mbed2fx)へのデータ送信処理
void websocket_send(char* writeBuf)
{
    int ret = 0;

    // Websocketサーバへデータを送信
    socket_mutex.lock();
    ret = ws_write->send(writeBuf);
    socket_mutex.unlock();

    // send処理が失敗した場合
    if (ret < 0) {
        printf("main() Websocket send error ret = %d\r\n", ret);
        mbed_die();
    }
}

// FX0からの受信メッセージ監視スレッド
// サンプルとしてFX0から受信メッセージの取得、LED点灯、消灯処理を行うスレッドを追加しています
void recv_thread(void const *argument) {
    int ret = 0;
    int loopCnt = 1;
    char *json = "";
    char readBuf[100] = "";
    char writeBuf[100] = "";

    while (true) {
        // Websocketサーバから受信メッセージを読み込み
        socket_mutex.lock();
        ret = ws_read->read(readBuf);
        socket_mutex.unlock();

        // 受信メッセージが存在する場合
        if (ret){
            // 受信メッセージ(JSON形式)を解析
            json = &(readBuf[0]);
            picojson::value v;
            string err = picojson::parse(v, json, json + strlen(json));
            if (! err.empty()) {
                printf(" parse error %s\r\n", err.c_str());
                continue;
            }
       
            // LED点灯、消灯処理を実行
            if (strcmp(v.get("method").get<string>().c_str(), "setLed") == 0) {
                doSetLed(writeBuf, v.get("led1").get<string>().c_str(), v.get("led2").get<string>().c_str(), v.get("led3").get<string>().c_str(), v.get("led4").get<string>().c_str());
                // Websocketサーバへ処理結果を送信
                websocket_send(writeBuf);
            } else {
                printf("Not Found Parameter\r\n");
            }
        }
        loopCnt++;

        // 500ms間隔でループ
        Thread::wait(500);
        
        // チャネルを閉じないようにするため、定期的にチャネルにデータを送信する
        if(loopCnt >= 50){
            loopCnt = 0;
            socket_mutex.lock();
            ret = ws_read->send("Keep Websocket Channel");
            socket_mutex.unlock();
        }
    }
}

// KTEC ADD E

int main() 
{
// KTEC ADD S
    int i=1;
    char wsWriteName[256] = "";
    char wsReadName[256] = "";
    char writeBuf[100] = "";
// KTEC ADD E

#if defined(TARGET_LPC1768)
    PHY_PowerDown();
#endif

    // WRITE_CHANNEL or READ_CHANNELが空の場合はエラー終了
    if ( "" == WRITE_CHANNEL || "" == READ_CHANNEL ){
        printf("error WRITE_CHANNEL or READ_CHANNEL NULL \r\n");
        mbed_die();
    }

// KTEC ADD S
    while (1) {
        printf("--- wifi_connect start(%d). ---\r\n", i);
        if( wifi_connect() == 0) 
        {
            break;
        }
        
        i++;
        if( i > 10 ) {
            mbed_die();
        }
        wait( i / 2 );
    }

    printf("wifi_connect end.\r\n");

    // Websocket生成
    sprintf(wsWriteName, "ws://sockets.mbed.org/ws/%s/wo", WRITE_CHANNEL);
    sprintf(wsReadName, "ws://sockets.mbed.org/ws/%s/ro", READ_CHANNEL);
    ws_write = new Websocket(wsWriteName);
    ws_read = new Websocket(wsReadName);
    
    // Websocketに接続
    ws_write->connect();
    ws_read->connect();

    // 受信メッセージを監視
    Thread thread(recv_thread);

    while (1) {
        wait(0.5);
        // ジャイロデータを取得
        doGetGyro(writeBuf);
        // ジャイロデータを送信
        websocket_send(writeBuf);              
    }
// KTEC ADD E

// KTEC DEL S
/*
    wifi.init(); //Use DHCP

    wait(0.5);
    int s = wifi.disconnect();
    if( s != 0 ) {
        return -1;
    }
    
    wait(0.3);
    // Connect AP
    wifi.connect( DEMO_AP_SSID
                        , strlen(DEMO_AP_SSID)
                        , DEMO_AP_SECURITY_TYPE
                        , DEMO_AP_SECUTIRY_KEY
                        , strlen(DEMO_AP_SECUTIRY_KEY) );
    wait(0.5);
    wifi.setIPConfig( true );    
    wait(0.5);    
    printf("IP Address is %s\n", wifi.getIPAddress());
    
    //GET data
    printf("\nTrying to fetch page...\n");
    int ret = http.get("http://developer.mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    printf("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    wifi.disconnect();  

    while(1) {
    }
*/
// KTEC DEL E
}
