/* Copyright (C) 2015 KDDI Technology, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "Websocket_Function.h"

// LED設定
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// ジャイロ設定
AnalogIn gyro1_adc(p16);
AnalogIn gyro2_adc(p17);

// Led1～4の点灯・消灯処理
// サンプルとしてLEDの点灯、消灯処理を追加しています
void doSetLed(char* output, string inputLed1, string inputLed2, string inputLed3, string inputLed4) {

    led1 = atoi(inputLed1.c_str());
    led2 = atoi(inputLed2.c_str());
    led3 = atoi(inputLed3.c_str());
    led4 = atoi(inputLed4.c_str());
    
    // outputにJSON形式で処理結果を返す
    sprintf(output, "{\"method\": \"setLed\", \"led1\": \"%d\", \"led2\": \"%d\", \"led3\": \"%d\", \"led4\": \"%d\"}",(int)led1 ,(int)led2 ,(int)led3 ,(int)led4);
}

// ジャイロ1,2データの取得、返却
// サンプルとしてジャイロ1,2データの取得、返却処理を追加しています
void doGetGyro(char* output) {
    float gy1_data;
    float gy2_data;
 
    // ジャイロ1,2データの読み込み
    gy1_data=gyro1_adc.read();
    gy2_data=gyro2_adc.read();

    // outputにJSON形式で処理結果を返す
    sprintf(output, "{\"method\": \"getGyro\", \"Gyro1\": \"%2.5f\", \"Gyro2\": \"%2.5f\"}",gy1_data ,gy2_data);
}
