#include "mbed.h"

#include "SNIC_WifiInterface.h"
// KTEC MOD START
//#include "HTTPClient.h"
#include "HTTPServer.h"
#include "RPC_Function.h"
// KTEC MOD END
#if defined(TARGET_LPC1768)
#include "PowerControl/EthernetPowerControl.h"
#endif

#define DEMO_AP_SSID                  "SSID"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_AES
#define DEMO_AP_SECUTIRY_KEY          "PASSWORD"
// KTEC ADD START
#define PORT_NUMBER     80
// KTEC ADD END

C_SNIC_WifiInterface     wifi( p9, p10, NC, NC, p30 );

#if defined(_DEBUG)
Serial pc(USBTX, USBRX);
#endif

// KTEC DEL START
/*
HTTPClient http;
char str[512];
*/
// KTEC DEL END

int main() 
{
#if defined(TARGET_LPC1768)
    PHY_PowerDown();
#endif

    wifi.init(); //Use DHCP

    wait(0.5);
    int s = wifi.disconnect();
    if( s != 0 ) {
// KTEC ADD START
        printf("wifi.disconnect error.\r\n");
// KTEC ADD END
        return -1;
    }
    
    wait(0.3);
    // Connect AP
// KTEC MOD START
    s = wifi.connect( DEMO_AP_SSID
                        , strlen(DEMO_AP_SSID)
                        , DEMO_AP_SECURITY_TYPE
                        , DEMO_AP_SECUTIRY_KEY
                        , strlen(DEMO_AP_SECUTIRY_KEY) );
    if( s != 0 ) {
        printf("wifi.connect error.\r\n");
        return -1;
    }
// KTEC MOD END
    wait(0.5);
    wifi.setIPConfig( true );    
    wait(0.5);    
    printf("IP Address is %s\n", wifi.getIPAddress());

// KTEC ADD START
    HTTPServer srv;
    
    printf("server init.\r\n");
    srv.init(PORT_NUMBER);
    
    wait(1);
    printf("server running.\r\n");
    srv.run();
// KTEC ADD END

// KTEC DEL START
/*
    //GET data
    printf("\nTrying to fetch page...\n");
    int ret = http.get("http://developer.mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    printf("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    wifi.disconnect();  

    while(1) {
    }
*/
// KTEC DEL END
}
