#include "RPCObject.h"
#include "parse_pins.h"
#include "mbed.h"
#include "HTTPServer.h"
// KTEC ADD START
#include "RPC_Function.h"
// KTEC ADD END

RPCObject::RPCObject()
{
}


int RPCObject::decode(char* request, char* reply)
{
// KTEC MOD START
    // 以下のようなURLで接続された場合は、関数を実行する
    // http://ipアドレス/rpc/setLed/1,0,1,1 LED1～4の点灯、消灯
    // http://ipアドレス/rpc/getGyro/ ジャイロ情報の取得
    char* rpc = strtok(request+1,"/");
    char* method = strtok(NULL, "/");
    char* param = strtok(NULL, "/");   
    DEBUG_PRINT("decode rpc = %s\r\n", rpc);
    DEBUG_PRINT("decode method = %s\r\n", method);
    DEBUG_PRINT("decode param = %s\r\n", param);

    if (strcmp(rpc, "rpc") == 0) {
        // LEDの点灯、消灯処理実行
        if (strcmp(method, "setLed") == 0) {
            DEBUG_PRINT("decode call doSetLed \r\n");
            doSetLed(param, reply);
        // ジャイロセンサーの値の取得処理実行
        } else if (strcmp(method, "getGyro")  == 0) {
            DEBUG_PRINT("decode call doGetGyro \r\n");
            doGetGyro(param, reply);
        } else {
            DEBUG_PRINT("decode Unsupported method = %s\r\n", method);
            return -1;
        }
    } else {
        DEBUG_PRINT("decode rpc does not exist in URL, rpc = %s \r\n", rpc);
        return -1;
    }
// KTEC MOD END

    return 0;
}


bool RPCObject::create_pin_object(char* reply) 
{
    RPCClass* pinobj;
    
    if(pinObjects.find(pin_name) != pinObjects.end()){
        printf("The pin already exists.\r\n");
        strcat(reply, "The pin already exists. ");
        return false;
    }
    
    switch(type){
    case RPC_PIN_DIGITAL_IN:
        printf("DigitalIn.\r\n");
        pinobj = new RPCDigitalIn(pin_name);
        break; 
    case RPC_PIN_DIGITAL_OUT:
        printf("DigitalOut.\r\n");
        pinobj = new RPCDigitalOut(pin_name);
        break;
    case RPC_PIN_DIGITAL_INOUT:
        printf("DigitalInOut.\r\n");
        pinobj = new RPCDigitalInOut(pin_name);
        break;
    default:
        printf(" Unsupported type.\r\n");
        strcat(reply, "Unsupported type. ");
        return false;
    }
    
    pinObjects[pin_name] = pinobj;   
    
    return true;
}
