/* Copyright (C) 2015 KDDI Technology, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "RPC_Function.h"

// LED設定
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// ジャイロセンサー設定
AnalogIn gyro1_adc(p16);
AnalogIn gyro2_adc(p17);

// Led1～4の点灯・消灯処理
// サンプルとしてLEDの点灯、消灯処理を追加しています
void doSetLed(char* input, char* output) {

    char *tok;
    char s2[] = ",";  // カンマで区切られていることを想定
    int cnt = 1;

    DEBUG_PRINT("doSetLed IN input = %s, output = %s\r\n", input, output);
  
    tok = strtok( input, "," );
  
    // カンマ区切りの文字列を取得し、1:LED点灯、０(1以外)：消灯とする
    while( tok != NULL ){
        int ret;
        int setled = 0;
        ret = strcmp( tok, "1" );
        if (ret == 0) {
            setled = 1;
        } else {
            setled = 0;
        }
        switch (cnt) {
        case 1:
            led1 = setled;
            break;
        case 2:
            led2 = setled;
            break;
        case 3:
            led3 = setled;
            break;
        case 4:
            led4 = setled;
            break;
        default:
            break;          
        }
        cnt++;
        tok = strtok( NULL, s2 );  // 2回目以降
    }

    // outputにJSON形式で処理結果を返す
    sprintf(output, "{\"led1\":%d, \"led2\":%d, \"led3\":%d, \"led4\":%d}",(int)led1, (int)led2, (int)led3, (int)led4);
}

// ジャイロセンサーの値の取得、返却処理
// サンプルとしてジャイロセンサーの値の取得、返却処理を追加しています
void doGetGyro(char* input, char* output) {
    float gy1_data;
    float gy2_data;
 
    // ジャイロ1,2データの読み込み
    gy1_data=gyro1_adc.read();
    gy2_data=gyro2_adc.read();

    // outputにJSON形式で処理結果を返す
    sprintf(output, "Gyro1:%2.5f, Gyro2:%2.5f",gy1_data ,gy2_data);
    DEBUG_PRINT("doGetGyro output = %s\r\n",output);
}