#ifndef RPCOBJECT
#define RPCOBJECT

#include <map>
#include "mbed.h"

enum RPC_PIN_TYPE {
    RPC_PIN_DIGITAL_IN,
    RPC_PIN_DIGITAL_OUT,
    RPC_PIN_DIGITAL_INOUT,
    RPC_PIN_UNKNOWN
};

struct rpc_arg
{
    char *name;
    char *val;
};

class RPCClass
{
    public :
        virtual int read()= 0;
        virtual void write(int value) = 0;
};

class RPCDigitalIn : public RPCClass
{
    public :
        RPCDigitalIn(PinName pin) :i(pin){}
        virtual int read(void){return i.read();}
        virtual void write(int value){}
       
    private :
        DigitalIn i;
};

class RPCDigitalOut : public RPCClass
{
     public :  
        RPCDigitalOut(PinName pin) :o(pin){}
        virtual int read(void){return o.read();}
        virtual void write(int value){o.write(value);}
    
    private :
        DigitalOut o;
};

class RPCDigitalInOut : public RPCClass
{
     public :  
        RPCDigitalInOut(PinName pin) :o(pin){}
        virtual int read(void){return o.read();}
        virtual void write(int value){o.write(value);}
    
    private :
        DigitalInOut o;
};

class RPCObject
{
    public :
        RPCObject();
        int decode(char *request, char* reply);
        
        RPC_PIN_TYPE get_type() const { return type; }
        PinName get_pin_name() const { return pin_name; }
        int get_value() const { return value; }
        bool create_pin_object(char* reply);
        std::map<PinName, RPCClass*> pinObjects;
        
    private :
        RPC_PIN_TYPE type;
        char obj_name[20];
        PinName pin_name;
        int value;
};
#endif

