#include "HTTPServer.h"
#include "mbed.h"


bool cmp(char* a, char* b)
{
    return strcmp(a,b) < 0;
}


HTTPServer::HTTPServer():
handlers(&cmp),
reply()
{
}


HTTPServer::~HTTPServer()
{
}


bool HTTPServer::init(int port)
{    
    DigitalOut led4(LED4);
    
    socketserver.set_blocking(true);
    if(socketserver.bind(port))
    {
        printf("Could not bind on port %d.\n", port);
        return false; 
    }
    
    if(socketserver.listen())
    {
        printf("Could not listen %d.\n", port);
        return false;
    }
    
    led4 = 1;  // server is ready
    
    return true;
}


void HTTPServer::run()
{
    char buffer[1024];
    TCPSocketConnection c;
    
    while(true)
    {
// KTEC MOD START
        // SNICInterface_modとNySNICInterfaceのIF差分が存在するため、変更
        //while(socketserver.accept(&c));
        while(socketserver.accept(c));
// KTEC MOD END
        c.set_blocking(false, 1000);
        
        while(c.is_connected())
        {
            int n = c.receive(buffer, sizeof(buffer)-1);
            if(n == 0)
            {
                c.close();
                break;
            }
            else if(n != -1)
            {
                buffer[n] = '\0';
                printf("Received data -- %s --. \r\n", buffer);
                handle_request(buffer);
                create_response(buffer);
                printf("Sending data -- %s --. \r\n", buffer);
                c.send_all(buffer, strlen(buffer));
                printf("done. \r\n");
                c.close();
                break;
            }
            else {
                printf("Error while receiving data. \r\n");
                c.close();
                break;
            }
        }
    }
}


void HTTPServer::handle_request(char *buffer)
{
    char* request_type = strtok(buffer, " ");
    char* request = strtok(NULL, " ");

    reply[0] = '\0';
    response_code = HTTP_404_NOTFOUND;

    if(!object.decode(request, reply)){
// KTEC MOD START
        // レスポンスコードを設定
        response_code = HTTP_200_OK;
        return;
    } else {
        response_code = HTTP_400_BADREQUEST;
        return;
    }
// KTEC MOD END

// KTEC DEL START
/*
    std::map<char*, RequestHandler*>::iterator itor = handlers.find(request_type);
    if(itor == handlers.end())
    {
        printf("No request handler found for this type of request.\r\n");
        return;
    }
    if(itor->second != NULL)
        response_code = itor->second->handle(object, reply);
    else
        printf("Invalid request handler\r\n");
*/
// KTEC DEL END
}

void HTTPServer::create_response(char *buffer)
{
    char content_length[30] = "";
    buffer[0] = '\0';
    
    /* HTTP Status Code */
    strcat(buffer, "HTTP/1.1 ");    
    switch(response_code){
    case HTTP_200_OK:
        strcat(buffer, "200 OK\r\n");
        break;
    case HTTP_404_NOTFOUND:
        strcat(buffer, "404 Not Found\r\n");
        break;
    default:
        strcat(buffer, "500 Internal Server Error\r\n");
        break;  
    }
    
    /* add header */
    strcat(buffer, "Access-Control-Allow-Origin: *\r\n");
    sprintf(content_length, "Content-Length: %d\r\n", strlen(reply));
    strncat(buffer, content_length, strlen(content_length));
    strcat(buffer, "Content-Type: text/plain\r\n\r\n"); 
    
    /* add content */
    strcat(buffer, reply);
}


void HTTPServer::add_request_handler(char *name, RequestHandler* handler)
{
    handlers[name] = handler;
    printf("%s request hander.\r\n", name);
}
