#include "mbed.h"

#include "SNIC_WifiInterface.h"
#include "HTTPClient.h"
#if defined(TARGET_LPC1768)
#include "PowerControl/EthernetPowerControl.h"
#endif

#define DEMO_AP_SSID                  "toyowata-nad11"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_AES
#define DEMO_AP_SECUTIRY_KEY          "mbed.org"

#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface     wifi( p9, p10, NC, NC, p30 );
#elif defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_L152RE)
C_SNIC_WifiInterface     wifi( D8, D2, NC, NC, D3);
#elif defined(TARGET_K64F)
C_SNIC_WifiInterface     wifi( D1, D0, NC, NC, D2);
#endif

Serial pc(USBTX, USBRX);

HTTPClient http;
char str[512];

int main()
{
#if defined(TARGET_LPC1768)
    PHY_PowerDown();
#endif

    pc.printf("WiFi init...\n");
    wifi.init();

    wait(0.5);
    int s = wifi.disconnect();
    if( s != 0 ) {
        return -1;
    }

    wait(0.3);
    // Connect AP
    wifi.connect( DEMO_AP_SSID
                  , strlen(DEMO_AP_SSID)
                  , DEMO_AP_SECURITY_TYPE
                  , DEMO_AP_SECUTIRY_KEY
                  , strlen(DEMO_AP_SECUTIRY_KEY) );
    wait(0.5);
    wifi.setIPConfig( true );     //Use DHCP
    wait(0.5);
    pc.printf("IP Address is %s\n", wifi.getIPAddress());

    int ret = 0;
#if 0
// disabled this test, since the library doesn't support HTTPS connection
    //GET data
    pc.printf("\nTrying to fetch page...\n");
    ret = http.get("http://developer.mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret) {
        pc.printf("Page fetched successfully - read %d characters\n", strlen(str));
        pc.printf("Result: %s\n", str);
    } else {
        pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
#endif

    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    pc.printf("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret) {
        pc.printf("Executed POST successfully - read %d characters\n", strlen(str));
        pc.printf("Result: %s\n", str);
    } else {
        pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    pc.printf("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret) {
        pc.printf("Executed PUT successfully - read %d characters\n", strlen(str));
        pc.printf("Result: %s\n", str);
    } else {
        pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    //DELETE data
    //HTTPText inText(str, 512);
    pc.printf("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret) {
        pc.printf("Executed DELETE successfully - read %d characters\n", strlen(str));
        pc.printf("Result: %s\n", str);
    } else {
        pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    wifi.disconnect();

    while(1) {
    }
}
