#include "mbed.h"

AnalogIn s1(p16);                //Entrada analógica do sensor

Ticker flipper;                  // Endereço da função a executarperiodicamente

DigitalOut led1(LED1);           // LED1 Indica que programa está a correr
DigitalOut led2(LED2);           // LED2 Indica que estão a ser enviadas amostras
DigitalOut led3(LED3);
DigitalOut a(p19);               //Controlar entrada A do multiplexer
DigitalOut b(p18);               //Controlar entrada B do multiplexer
AnalogOut vref(p18);
DigitalOut c(p17);               //Controlar entrada C do multiplexer
DigitalOut pot1(p6);                //Chip select para potenciometro 1 R1 do divisor de tensão   
DigitalOut pot2(p8);                //Chip select para potenciometro 2 R1 da ponte
DigitalOut pot3(p29);               //Chip select para potenciometro 1 R2 da ponte
DigitalOut pot4(p9);                //Chip select para potenciometro 4 Ganho do AmpOp

Serial pc(USBTX,USBRX);          //Comunicação Serial

SPI pot(p5,NC,p7);               //Comunicação SPI para potenciometros digitais

int state = 0;                   //Utilizado na leitura das mensagens
bool start = false;              //Dá ordem para iniciar ou não as medições   
char incoming;
int saida = 0;                   //Define que sensores irão ser lidos
float resDiv = 0.0;

//*************************************************
//Coloca todos os sensores ativos uma vez por ciclo
//*************************************************
bool varrerSensores(){
        
    a = saida && 0b001;
    //b = saida && 0b010;
    c = saida && 0b100;
    
    if(saida < 0b111)
    {
        return true;
    }
    else
    {
        saida = 0;
        return false;
    }   
}

//*************************************
//Calibração de ponte/divisor de tensão
//*************************************
void calib(int res){
    
    pot1 = 1;
    pot2 = 1;
    pot3 = 1;
    pot4 = 1;
    int msg = res/2;
    pot.lock();
    pot1 = 0;
    
    pot.write(msg);
    
    pot1 = 1;
    pot.unlock();
}

void mensagem(float amostra){
    int msg[] = {0xFF, saida++, 0, 0};
     msg[2] = (int) (amostra/256);                 //Define byte mais significativo
     msg[3] = amostra-msg[2]*256;                  //Define byte enos significativo
        
    for(int i = 0; i < 4; i++){                   //Envia mensagem completa
        pc.putc(msg[i]);
    }
}

//*************************************************************************************
// Aquisição de dados
//*************************************************************************************
void flip()
{  
  if(start){                        //Se o botao start foi pressionado     
    float amostra;
    while(varrerSensores()){
        led2 = 1;                       //Acende LED para dar sinal de inicio de amostragem      
        
        amostra = 0;                         //Onde são guardados os valores amostrados
        
        int msg[] = {0xFF, saida++, 0, 0};          //Mensagem a enviar saida++ aqui para o zero entrar também                   
        int n_amostras = 50;                        //N de amostras a fazer em cada medição para limpar o ruido
        int fatorMult = 1000;                       //Multiplicador para que se possa enviar apenas valores inteiros
        
        for(int i = 0; i < n_amostras; i++)         //Faz n_amostras medições para cada amostra enviada
        {          
            amostra += s1.read();
        }
        
        amostra = amostra*3.300*fatorMult/n_amostras; //Calcula o valor a enviar na mensagem 3.3 é a tensão máxima
        
        msg[2] = (int) (amostra/256);                 //Define byte mais significativo
        msg[3] = amostra-msg[2]*256;                  //Define byte enos significativo
        
    for(int i = 0; i < 4; i++){                   //Envia mensagem completa
        pc.putc(msg[i]);
    }
  
    led2 = 0;                                     //Acabou uma amostra desliga o led
  }
  }                                         
}



//*********************************************
//Leitura de mensagens recebidas
//*********************************************
void pc2mbed() {
    
    if (pc.readable()) {
        incoming = pc.getc();    
        switch(state)
        {
            case(0):
                if(incoming == 0xFF)    //Nova mensagem
                {
                    state = 1;
                }
            break;
            
            case(1):
                if(incoming == 0x01)    //Mensagem de ordem de start/stop
                {
                    state = 2;
                }
                else if(incoming == 0x02)//Mensagem de setup
                {
                    state = 3;            
                }
            break;
            
            case(2):
                if(incoming == 0x00){
                    start = true;
                    }
                else if(incoming == 0x01){
                    start = false;
                }
                    state = 0; 
            break;
            
            case(3):
                //resDiv = 0;
                resDiv = incoming;
                vref = resDiv/100;
                //state = 4;
                state = 0;
            break;
            
            case(4):
                resDiv = resDiv || incoming;
                calib(resDiv);
                state = 0;
            break;
            
            default:
                break;
        }          
    }
}

//*************************************************************************************
// Rotina Principal
//*************************************************************************************
int main()
{
// Inicialização dos LED
    led1 = 0;                 // LED off
    led2 = 0;
    calib(20);
    vref = 0.5;
// Rotina de aquisição de dados executada a cada 5x/segundo
    flipper.attach(&flip, 0.1);
    
// Rotina de leitura de dados na porta serial    
    pc.attach(&pc2mbed, Serial::RxIrq);

// Entra em espera com LED1 a piscar
    while(1)
    {    
      led1 = 1;
      wait(1);
      led1 = 0;
      wait(1);
    }
}

  //FILE *fp = fopen("/local/out.txt", "a");             // Abreficheiro em modo "append"