#include "mbed.h"
#include "m3pi.h"

m3pi m3pi;

// DigitalOuts
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Minimum and maximum motor speeds
#define MAX 0.80
#define MIN 0

// PID terms
#define P_TERM 1
#define I_TERM 0
#define D_TERM 20

// Ccount before test
#define CYCLEBEFORETEST 1500

// Textfile paths
#define PITLOGPATH "/local/pitlog.txt"
#define VOLTAGELOGPATH "/local/voltage.txt"


// Prototypes
int PS_BatteryTest(void);   // Test if to robot needs to goto pit 
void InitialMessages(void); // Prints initial message to the LCD 
void LED_Control(int ledNumber, int state); //Turn ledNumber to 1=on, 0 = off
void LED_Blink(int ledNumber); // Make ledNumber blinik
void LCDCountDown(int num);  //LCD Coundown function


void PS_PitStop(void); // 
void PS_CreateLog(void); // create a log file or resets it (WIP
void PS_AddStopToLog(void); // Add one to the log
// void PS_DisplayNumberofPS(void);  // Display the final number on screen WIP

void TE_CreateVoltageLog(void); //
void TE_LogVoltage(int count); // test funktion that write the woltage each time the battry is checked

int main() {
    LocalFileSystem local("local"); 
    
    
    /*Base program Variable initiation*/
    float right;
    float left;
    float current_pos_of_line = 0.0;
    float previous_pos_of_line = 0.0;
    float derivative,proportional,integral = 0;
    float power;
    float speed = MAX;

    /*Team 7 Variabels*/
    int gotoPit = 0; // wether or not the robot is heading to pit. Initialstate false. 
    int ccount = 0; //used to count cycles
    
    /*Printing secret cat mission*/
    InitialMessages();
    m3pi.sensor_auto_calibrate();
    
    
    /*Create pitlog used to log the number of pitstop */
    PS_CreateLog();
    TE_CreateVoltageLog();

    while (1) {
        /* If cycle count divided by 100 does not have a rest. test if pit */
        if (ccount % CYCLEBEFORETEST == 0 && gotoPit == 0)
        {
            TE_LogVoltage(ccount);
            gotoPit = PS_BatteryTest();
        }
        if (gotoPit == 1)
        {
            /*Add one to the nummber allready in the pitlog*/
            PS_AddStopToLog();
            /*Run the pitstop function*/
            PS_PitStop();
        }
            
        // Get the position of the line.
        current_pos_of_line = m3pi.line_position();        
        proportional = current_pos_of_line;
        
        // Compute the derivative
        derivative = current_pos_of_line - previous_pos_of_line;
        
        // Compute the integral
        integral += proportional;
        
        // Remember the last position.
        previous_pos_of_line = current_pos_of_line;
        
        // Compute the power
        power = (proportional * (P_TERM) ) + (integral*(I_TERM)) + (derivative*(D_TERM)) ;
        
        // Compute new speeds   
        right = speed+power;
        left  = speed-power;
        
        // limit checks
        if (right < MIN)
            right = MIN;
        else if (right > MAX)
            right = MAX;
            
        if (left < MIN)
            left = MIN;
        else if (left > MAX)
            left = MAX;
            
       // set speed 
        m3pi.left_motor(left);
        m3pi.right_motor(right);
        
    ccount++;
    }
    // PS_DisplayNumberofPS();
    
}

void InitialMessages(void){
    /*Prints iniatl secret mission*/
    
    
    
    m3pi.cls();
    m3pi.locate(0,0);
    m3pi.printf("DESTROY");
    m3pi.locate(0,1);
    m3pi.printf("**CATS**");
    wait(5.0);
    
    m3pi.cls();
    m3pi.locate(0,0);
    m3pi.printf("%4.4f ",m3pi.battery());
    m3pi.locate(0,1);
    m3pi.printf("%4.4f ",m3pi.pot_voltage());
    wait(10.0);
    m3pi.cls();
    m3pi.locate(0,0);
    m3pi.printf("ROBOT ON");
    m3pi.locate(0,1);
    m3pi.printf("TRACK!!");
    wait(4.0);
    LCDCountDown(3);
    m3pi.cls();
    m3pi.locate(0,0);
    m3pi.printf("** GO **");
}
    
void LCDCountDown(int num){
    for (int i=0; i<num; i++)
    {
       m3pi.cls();
       m3pi.locate(0,0); 
       m3pi.printf("** %d **", i );
       wait(1.0);
    }
    
}     
    
int PS_BatteryTest(void){
/* Test battery voltage, if the robot is not headed for pit */ 
    
    const float BATVOLTTRESHOLD = 4.2; // Treshold i volt
    int result = 0;
    int BatteryTestCounter;
    
    /*Test if the voltage is below the threshold if true 10 times in row,
     turn on go to pit mode*/
    if (m3pi.battery() <= BATVOLTTRESHOLD ){  
        if (++BatteryTestCounter > 3){
            result = 1; // Set goto pit condition
            LED_Control(1, 1);
            m3pi.cls();
            m3pi.locate(0,0);
            m3pi.printf("Going to");
            m3pi.locate(0,1);
            m3pi.printf("**PIT**");
        }
    }
    else {
        // If battery is above threshold, reset counter
        BatteryTestCounter = 0; 
    }
    return result;
}

void LED_Control(int ledNumber, int state){
    //LED1 on if robot is looking for pit
    if (ledNumber == 1) {
        led1 = state;
    }
    if (ledNumber == 2){
        led2 = state;
    }
    if (ledNumber == 3){
        led3 = state;
    }
    if (ledNumber == 4){
        led4 = state;
    }
}

void LED_Blink(int ledNumber)
{
    int a = 2;
    LED_Control (ledNumber , 0);
    wait(a);
    LED_Control (ledNumber , 1);
    wait(a);
    }

void PS_PitStop(void)
{
    /* Testing alternative stop function
    m3pi.left_motor(0);
    m3pi.right_motor(0);
    */
    m3pi.stop();       // stop all engine
    
    // increase counter with one
    while (1)
    {
        LED_Blink (1);      // signal in pit
        
/* missing input to stop blink. */
        
    }
}

void PS_CreateLog(void){
/* Create a pitlog file and test if it can open*/
    FILE *fptr;
    fptr = fopen(PITLOGPATH,"w");

    if(fptr == NULL)
         {
            printf("Error creating log file ");
            exit(1);
         }
    fprintf(fptr,"%d", 0);
    fclose(fptr);
}

void PS_AddStopToLog(void){
    /*Opens the pit log and read the number.
     * Then adds one to that number at write it into the pitlog */

    FILE *fptr;
    int x, y;
    if ((fptr = fopen(PITLOGPATH,"r")) == NULL){
        printf("Error! opening file");
        // Program exits if the file pointer returns NULL.
        exit(1);
       }

    fscanf(fptr,"%d", &x);
    fclose(fptr);

    y = x+1;
    fptr = fopen(PITLOGPATH,"w");

    if(fptr == NULL)
        {
             printf("Error creating log file ");
             exit(1);
        }
    fprintf(fptr,"%d", y);
    fclose(fptr);
}

/*
void PS_DisplayNumberofPS(void){
    // Display the number i the pitstop recorded in the logfile
    FILE *fptr;
    int x;
    if ((fptr = fopen(PITLOGPATH,"r")) == NULL){
        printf("Error! opening file");
        // Program exits if the file pointer returns NULL.
        exit(1);
       }
     fscanf(fptr,"%d", &x);
     printf("Final number of pits stops %d", x);
     fclose(fptr);
}
*/

void TE_CreateVoltageLog(void){
/* Create a voltagelog file and test if it can open*/
    FILE *fptr;
    fptr = fopen(VOLTAGELOGPATH,"w");

    if(fptr == NULL)
         {
            printf("Error creating log file ");
            exit(1);
         }
    
    fclose(fptr);
}

void TE_LogVoltage(int count){
/* Create a pitlog file and test if it can open*/
    FILE *fptr; /* voltagelog adres */
    fptr = fopen(VOLTAGELOGPATH,"a");
  
    fprintf(fptr," %8d      %4.4f      %4.4f \n"  ,count, m3pi.battery(),m3pi.pot_voltage()  );
    fclose(fptr);
}