/* Náum í gagnasöfn */
#include <iostream>
#include <stdlib.h> 
#include <algorithm>
using namespace std;
#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include <ctime>

//Skilgreiningar fyrir takka og led ljós
InterruptIn button1(USER_BUTTON);
volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Notað fyrir debouncing
Timeout button1_timeout; // Notað fyrir debouncing
DigitalOut led1(LED1);

/* Skilgreinum X-Nucleo skjöldinn */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Náum í grunneiningar skjaldarinns */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;

/* Hjálparfall til að prenta floats og doubles (tilbúið fall með athugasemdum á ensku)*/
static char *printDouble(char* str, double v, int decimalDigits=2)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if(fractPart >= i) break;
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}

// Fall sem virkjar takkann þegar bouncing er búið
void button1_enabled_cb(void)
{
    button1_enabled = true;
}

// ISR meðhöndlun þegar ýtt er á takkann
void button1_onpressed_cb(void)
{
    if (button1_enabled) { // Slökt á meðan að takki er bouncing
        button1_enabled = false;
        button1_pressed = true; 
        button1_timeout.attach(callback(button1_enabled_cb), 0.3); // Debounce tími 300 ms
    }
}

/* Tilfelli 1, fall sem prentar út hitastig, rakastig og loftþrýsting í umhverfi brettisins */
void tilfelli1() {
    printf("\r\n");
    printf("Tilfelli 1 valið: \r\n");
    
    float value1, value2;
    char buffer1[32], buffer2[32];
    
    /* Lesum hitastig og rakastig og prentum út */
    temp_sensor1->get_temperature(&value1);
    humidity_sensor->get_humidity(&value2);
    printf(" Hitastig:     %7s°C\n Rakastig:       %s%%\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));  
    
    /* Lesum loftþrýsting og prentum út */
    pressure_sensor->get_pressure(&value2);
    printf(" Loftþrýstingur: %s mbar\r\n", printDouble(buffer2, value2));
    
    printf("\n");
}

/* Tilfelli 2, fall sem prentar út segulstefnu, hröðun og hornhröðun brettisins í þrívíðum hnitum */
void tilfelli2() {
    printf("\r\n");
    printf("Tilfelli 2 valið: \r\n");
    
    char buffer1[32], buffer2[32];
    int32_t axes[3];
    
    /* Lesum segulstefnur og prentum út */
    magnetometer->get_m_axes(axes);
    printf(" Segulstefnur:  %7ld, %7ld, %7ld\r\n", axes[0], axes[1], axes[2]);
    
    /* Lesum hröðunarmerki og prentum út */
    accelerometer->get_x_axes(axes);
    printf(" Hröðun:        %7ld  %7ld, %7ld\r\n", axes[0], axes[1], axes[2]);
    
    /* Lesum hornhröðunarmerki og prentum út */
    gyroscope->get_g_axes(axes);
    printf(" Hornhröðun:    %7ld, %7ld, %7ld\r\n", axes[0], axes[1], axes[2]);
    
    printf("\n");
}

/* Tilfelli 3, fall sem samsvarar takkavalmynd */
void tilfelli3() {
    printf("\r\n");
    printf("Tilfelli 3 valið: \r\n");
    printf("Ýttu 1 sinni á takkann til að fá stöðu brettisins einu sinni. \r\n");
    printf("Ýttu 2 sinnum á takkann til að athuga hvort brettið sé upprétt einu sinni. \r\n");
    printf("Ýttu 3 sinnum á takkann til að fá stöðu brettisins í rauntíma. \r\n");
    printf("Ýttu 4 sinnum á takkann til að fara til baka í aðalvalmynd. \r\n");
    
    button1.fall(callback(button1_onpressed_cb)); // Viðhengja ISR til að meðhöndla þegar ýtt er á takka

    int idx = 0; // Teljari fyrir hversu oft ýtt er á takka
    
    /* Lykkja fyrir takkavalmynd */
    while(1) {   
        idx = 0; // Endurræsum teljara
        if (button1_pressed) { 
            button1_pressed = false;
            clock_t time = clock();
            idx++;
            /* Lykkja sem gefur notanda 3 sek til að ýta á takkan eins oft og notandi vill */
            while ((clock() - time) / CLOCKS_PER_SEC < 3) {
                if (button1_pressed) {
                    button1_pressed = false;
                    idx++; // Hækkum teljara ef ýtt er á takka   
                }
            } 
        }
        
        /* Ef ýtt er á takka þá prentast út hversu of ýtt var á hann */
        if (idx > 1) {
            printf("\r\n");
            printf("Þrýst á takkann %d sinnum. \r\n", idx);
        }
        else if (idx == 1) {
            printf("\r\n");
            printf("Þrýst á takkann %d sinni. \r\n", idx);
        }
        
        if (idx == 1) {
            /* Staða reiknuð út */
            char buffer1[32], buffer2[32];
            int32_t axes[3];
            accelerometer->get_x_axes(axes);
            int max_1 = max(abs(axes[0]), abs(axes[1]));
            max_1 = max(max_1, abs(axes[2]));
            
            /* Niðurstaða prentuð út */
            printf("Hlið brettisins sem snýr upp á við er: ");
            
            if (max_1 == abs(axes[0])) {
                if (max_1 == axes[0]) {
                    printf("HÆGRI HLIÐIN. \n");
                } else {
                    printf("VINSTRI HLIÐIN. \n");
                }
            }
            else if (max_1 == abs(axes[1])) {
                if (max_1 == axes[1]) {
                    printf("FRAM HLIÐIN. \n");
                } else {
                    printf("BAK HLIÐIN. \n");
                }
            } 
            else if (max_1 == abs(axes[2])) {
                if (max_1 == axes[2]) {
                    printf("TOPP HLIÐIN. \n");
                } else {
                    printf("BOTN HLIÐIN. \n");
                }
            }  
        } 
        /* Ef ýtt er 2 sinnum á takkann */
        else if (idx == 2) {
            cout << "Ljós helst stöðugt í 2 sek ef brettið er upprétt, annars blikkar það." << endl;
            
            /* Staða reiknuð út */
            char buffer1[32], buffer2[32];
            int32_t axes[3];
            accelerometer->get_x_axes(axes);
            int max_1 = max(abs(axes[0]), abs(axes[1]));
            max_1 = max(max_1, abs(axes[2]));
            
            /* Ef brettið er upprétt helst ljós kveikt í 2 sek en annars blikkar það í 2 sek */
            if (max_1 == axes[2]) {
                clock_t time = clock();
                while ((clock() - time) / CLOCKS_PER_SEC < 2) {
                    led1 = true;
                }
            } else {
                clock_t time = clock();
                while ((clock() - time) / CLOCKS_PER_SEC < 2) {
                    led1 = !led1;
                    wait(0.2);
                }
            }
            led1 = false;
        }
        /* Ef ýtt er 3 sinnum á takkann */
        else if (idx == 3) {
            printf("Ljós helst stöðugt ef brettið er upprétt, annars blikkar það. \r\n");
            printf("Ýttu 3 sinnum á takkann til að fara til baka í takkavalmynd. \r\n");
            
            /* Lykkja til að sýna hvort brettið sé upprétt í rauntíma með led ljósinu */
            while(1){
                idx = 0; // Teljari
                if (button1_pressed) { // Ef ýtt
                    button1_pressed = false;
                    clock_t time = clock();
                    idx++; // Teljari hækkaður 
                    /* Gefnar 3 sek til að ýta á takka */
                    while ((clock() - time) / CLOCKS_PER_SEC < 3) {
                        if (button1_pressed) {
                            button1_pressed = false;
                            idx++; // Teljari hækkaður  
                        }
                    } 
                }
                
                /* Ef ýtt er þrisvar sinnum á takkan er farið aftur í takkavalmynd */
                if (idx == 3) {
                    led1 = 0; // Slökkt á led ljósinu
                    break;
                }
                
                /* Staða reiknuð út */
                char buffer1[32], buffer2[32];
                int32_t axes[3];
                accelerometer->get_x_axes(axes);
                int max_1 = max(abs(axes[0]), abs(axes[1]));
                max_1 = max(max_1, abs(axes[2]));
                
                /* Ef brettið er upprétt helst ljós kveikt en annars blikkar það */
                if (max_1 == axes[2]) {
                    led1 = 1;
                } else {
                    led1 = !led1;
                    wait(0.2);
                }
            }
        }
        
        /* Fara til baka í aðalvalmyn ef ýtt er á takkann fjórum sinnum */
        else if (idx == 4) {
            printf("Farið til baka í aðalvalmynd. \r\n");
            printf("\r\n");
            break;
        }
        
        /* Prenta valmöguleika aftur ef á við */
        if (idx > 0 and idx < 4) {
            printf("\r\n");
            printf("Ýttu 1 sinni á takkann til að fá stöðu brettisins einu sinni. \r\n");
            printf("Ýttu 2 sinnum á takkann til að athuga hvort brettið sé upprétt einu sinni. \r\n");
            printf("Ýttu 3 sinnum á takkann til að fá stöðu brettisins í rauntíma. \r\n");
            printf("Ýttu 4 sinnum á takkann til að fara til baka í aðalvalmynd. \r\n");
        }
        else if (idx > 0) {
            printf("Ekkert gerist. \r\n");
        }
    }
}

/* Einfalt main-fall sem samsvarar aðalvalmynd */
int main() { 
  while(1) {
    int userInput;
    cout << "Veldu tilfelli 1-3: " << endl;
    cout << "Veldu 1 til að fá hitastig, rakastig og loftþrýsting." << endl;
    cout << "Veldu 2 til að fá segulstefnu, hröðun og hornhröðun brettisins í þrívíðum hnitum." << endl;
    cout << "Veldu 3 til að opna takkavalmynd." << endl;
    cin >> userInput; // Fáum tölugildi frá notanda
    switch(userInput) {
        case 1: tilfelli1();
        break;
        case 2: tilfelli2();
        break;
        case 3: tilfelli3();
        break;
        default: break;    
    } 
  }
}

