#include "mbed.h"
#include "log.h"
#include "DAC.h"
#include "mcp4725.h"
#define GROUP_ID 2
Timer programTimer;
//Timer DACC_timer;
//DigitalOut testLed(LED1);
Ticker read;
CAN can2(p30,p29);
DigitalOut led2(LED2);

void canread() {
    CANMessage msg;
     if(can2.read(msg)) {
        led2 =! led2;
        if( msg.id == GROUP_ID){
            logMessage( "To our group: Receive command %d %d %d! \n", msg.data[0],msg.data[1],msg.data[2]);
            // data[0]: 1 -> on , 0->off
            // data[1]: 1 -> sine, 0->square
            // data[2]: 1 -> 1HZ, 0->10HZ
            //DAC-on
            if( msg.data[0] == 1){
                DAC_start();
                //freq 1HZ
                if( msg.data[1] == 1){
                    //sine
                    if(msg.data[2] == 1){
                        DAC_set(3.0, FREQ_1HZ,FORM_SIN);
                        logMessage("Set sine wave, 1hz \n");
                    }
                    else{
                        DAC_set(3.0, FREQ_1HZ,FORM_SQUARE);
                        logMessage("Set square wave, 1hz \n");
                    }
                }
                //freq 10HZ
                else{
                    //sine
                    if(msg.data[2] == 1){
                        DAC_set(3.0, FREQ_10HZ,FORM_SIN);
                        logMessage("Set sine wave, 10hz \n");
                    }
                    else{
                        DAC_set(3.0, FREQ_10HZ,FORM_SQUARE);
                        logMessage("Set square wave, 10hz \n");
                    }
                }
            }
            //DAC-off
            else{
                DAC_stop();
                logMessage("Turn off !\n");
            }
        }
        else{
            logMessage("Recevie command to group %d \n",msg.id);
        }
    }
}

int main()
{    
    DAC_set(3.0, FREQ_1HZ, FORM_SQUARE);
    programTimer.start();  
    logMessage( "Finish initilized! \n");
    read.attach(&canread,1);      
    while(1) {
        DAC_generate();
    }
    

}