#include "mbed.h"
#include "mcp4725.h"
#include "DAC.h"
#include "math.h"
#include "log.h"

#define PI 3.1415926
MCP4725 controller(p9, p10, MCP4725::Fast400kHz, DEVICE_ADDR_BIT);
Timer DAC_timer;

bool volatile DAC_running = false;
float p_range = 0;
enum FREQ p_freq = FREQ_10HZ;
enum FORM p_form = FORM_SQUARE;

void DAC_start(){
    DAC_running = true;
}

void DAC_stop(){
    DAC_running = false;
}
void DAC_set(float range, enum FREQ freq, enum FORM form){
    p_range = range;
    p_freq = freq;
    p_form = form;
}

void DAC_generate(){
    float Vout = 0;
    int time_us = 0;
    DAC_timer.start();  
    while( DAC_running ){
        if( p_form == FORM_SQUARE ){
            if( p_freq == FREQ_10HZ ){
                //generate square wave at 10HZ
                if( (int)time_us % 100000 <= 50000){ // T = 100 ms
                    Vout = p_range;
                }
                else 
                    Vout = 0;          
            }
            else{
                //generate square wave at 1HZ               
                if( (int)time_us % 1000000  <= 500000) //T = 1 s
                    Vout = p_range;
                else 
                    Vout = 0;
            }
        }
        else if ( p_form == FORM_SIN){
            if( p_freq == FREQ_10HZ ){
                Vout = p_range / 2.0 * (sin( 2.0 * PI * 10.0 * time_us / 1000000.0) + 1);                
            }
            else{
                //generate sin wave at 1HZ
                Vout = p_range / 2.0 * (sin( 2.0 * PI * 1.0 * time_us / 1000000.0) + 1);
            }
        }
        wait_us(1000); //delay 1 ms
        time_us += 1000;
        controller.write(MCP4725::Normal, (0xFFF * (Vout/VDD_VOLTAGE) ), false);
    }
    DAC_timer.stop();
    DAC_timer.reset();
    
}