#ifndef USBBT_H
#define USBBT_H
#include "UsbHostMgr.h"
#include "UsbEndpoint.h"
#include "UsbBaseClass.h"

#define HCI_COMMAND_DATA_PACKET	0x01
#define HCI_ACL_DATA_PACKET	    0x02
#define HCI_SCO_DATA_PACKET	    0x03
#define HCI_EVENT_PACKET	    0x04

class usbbt : public UsbBaseClass {
public:
    usbbt(int dongle = 0);
    int setup(int timeout = 9000);
    int send_packet(uint8_t packet_type, uint8_t* packet, int size);
    void poll();
    ///Setups the result callback
    /**
     @param pMethod : callback function
     */
    void setOnPacket( void (*pMethod)(uint8_t, uint8_t*, uint16_t) );
  
    ///Setups the result callback
    /**
    @param pItem : instance of class on which to execute the callback method
    @param pMethod : callback method
    */
    class CDummy;
    template<class T> 
    void setOnPacket( T* pItem, void (T::*pMethod)(uint8_t, uint8_t*, uint16_t) )
    {
        m_pCb = NULL;
        m_pCbItem = (CDummy*) pItem;
        m_pCbMeth = (void (CDummy::*)(uint8_t, uint8_t*, uint16_t)) pMethod;
    }
    void clearOnPacket();
private:
    int ParseConfiguration();
    void onPacket(uint8_t packet_type, uint8_t* packet, uint16_t size);
    int m_dongle;
    UsbDevice* m_pDev;
    UsbEndpoint* m_pEpIntIn;
    UsbEndpoint* m_pEpBulkIn;
    UsbEndpoint* m_pEpBulkOut;
    Timer m_timer;
    int m_int_seq;
    uint8_t m_int_buf[64];
    int m_bulk_seq;
    uint8_t m_bulk_buf[64];
    CDummy* m_pCbItem;
    void (CDummy::*m_pCbMeth)(uint8_t, uint8_t*, uint16_t);
    void (*m_pCb)(uint8_t, uint8_t*, uint16_t);
};
#endif //USBBT_H