/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef USB_MEM_H
#define USB_MEM_H

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char byte;

void usb_mem_init();

volatile byte* usb_get_hcca();

volatile byte* usb_get_ed();

volatile byte* usb_get_td(uint32_t endpoint);
volatile byte* usb_get_itd(uint32_t endpoint);

volatile byte* usb_get_bp(int size);
int usb_bp_size();

void usb_free_ed(volatile byte* ed);

void usb_free_td(volatile byte* td);

void usb_free_itd(volatile byte* itd);

void usb_free_bp(volatile byte* bp);

bool usb_is_td(volatile byte* td);
bool usb_is_itd(volatile byte* td);

#ifdef __cplusplus
}
#endif

#endif
