#include "mbed.h"
#include "uvc.h"
#define __DEBUG
#include "mydbg.h"

UsbErr uvc::Control(int req, int cs, int index, uint8_t* buf, int size)
{
    UsbErr rc;
    if (req == SET_CUR) {    
        rc = m_pDev->controlSend(
                    USB_HOST_TO_DEVICE | USB_REQUEST_TYPE_CLASS | USB_RECIPIENT_INTERFACE, 
                    req, cs<<8, index, buf, size);
        return rc;
    }
    rc = m_pDev->controlReceive(
                USB_DEVICE_TO_HOST | USB_REQUEST_TYPE_CLASS | USB_RECIPIENT_INTERFACE, 
                req, cs<<8, index, buf, size);
    return rc;
}
