#include "StateSW.h"
#include "mbed.h"

StateSW::StateSW(PinName SWPin) : _SW(SWPin) {}

void StateSW::Enable(int StateNum, int NoiseCancel, int OpenTime)  {  // _PRSCNT -- unit [times] ,_OPNCNT -- unit [s]
    _STATENUM = StateNum;
    _REPEAT   = NoiseCancel;
    _OPNCNT   = OpenTime;
    _preSW = 1;
    _PressCount= 0;
    _IfCntOpen = 0;
    _IfCntClose= 0;
    _IfCntState= 0;
    _IfAtTime  = 0;

    _StateCounter.attach(this, &StateSW::_SeekPress, 0.05); // Ticker[s]
}

int  StateSW::State(void){
    return _State;
}

bool StateSW::IfAtTime(void){
    return _IfAtTime;
}

void StateSW::IfCntState(bool IfCntState){
    _IfCntState = IfCntState;
}

void StateSW::IfCntClose(bool IfCntClose){
    _IfCntClose = IfCntClose;
    if(_IfCntClose == 0 ){
        _Timer_SW.stop();
        _Timer_SW.reset();
    }
}
void StateSW::IfCntOpen(bool IfCntOpen){
    _IfCntOpen = IfCntOpen;
    if(_IfCntOpen == 0 ){
        _Timer_SW.stop();
        _Timer_SW.reset();
    }
}

/*
void StateSW::Reset(void){
    
}
bool StateSW::IfOnetime(void){
    if(IfOnetime==1){
        IfOnetime = 0;
        return 1;
    }
    else return 0;
}
*/
void StateSW::_SeekPress(void)  {        // instead of InterruptIn  -- for against noise
    if(_preSW != _SW)  _PressCount++;
    else               _PressCount=0;
    if(_PressCount > _REPEAT )  {
        if(_SW) StateSW::_rise();
        else    StateSW::_fall(); 
        _preSW = _SW;
        _PressCount = 0;
    }
    if(_Timer_SW.read() > _OPNCNT){
        _Timer_SW.stop();
        _Timer_SW.reset();
        _IfAtTime =1;
    }
}

void StateSW::_fall(void) {
    if(_IfCntOpen == 1 ){
        _Timer_SW.stop();
        _Timer_SW.reset();
    }
    if(_IfCntClose== 1 ) _Timer_SW.start();
}

void StateSW::_rise(void) {
    if(_IfCntOpen == 1 ) _Timer_SW.start();
    if(_IfCntClose== 1 ){
        _Timer_SW.stop();
        _Timer_SW.reset();
    }
    if(_IfCntState) {
        _State++;
        _State = _State%_STATENUM;
//      IfOnetime=1;
    }     
}


