/**
* @file main.cpp
* @brief Ver3.0 Sample source code for MIP8 diplay. 
* @details  
*
* Ver3.0 Addtional function is font display. this demo code is tha degit is counted up like a meter panel
* ver2.0 Addtional function is Monochome display by 1bit mode of SPI transfer.
*
* spi-transfer to Display has 3 mode. 
* 4bit mode is color display, this bit arrange is  R,G,B,x.   R,G,B = R,G,B subpixel bit.  a x bit is Dummy.
* No ues(3bit mode is color display, this bit arrange is  R,G,B.   R,G,B = R,G,B subpixel bit.  No bit is Dummy.)
* 1bit mode is monocrome display,high speed refresh mode. a only Green subpixel of bitmap data is transfered.
* <License>
* Copyright 2018 Japan Display Inc.
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
#include "stdio.h"
#include "string"
#include "mbed.h"
#include "MIP8F_SPI.h"
#include "SDFileSystem.h"
#include "StateSW.h"
#include "TglSW.h"

#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "Arial37x36.h"
#include "Arial42x42.h"
#include "font_big.h"
#include "Arial94x94.h"
//#include "Prototype29x28.h"
//#include "Prototype70x86.h"
//#include "HGP23x29.h"
//#include "HGP15x19.h"
//#include "symbol.h"

#define ON  1
#define OFF 0

//K64F
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // mosi,miso,sck,cs
memLCD8 WD(PTD2,PTD3,PTD1,PTD0,PTC4,PTD3); //PTC12);  // mosi,miso,clk,cs,disp,power
PwmOut BK(PTC3);
PwmOut COM60HZ(PTC10);    //add 20161108 
DigitalOut COMSEL(PTA2,0);    //add 20161108
DigitalOut BLCTRL(PTB10,0);    //add 20171115
// SW2
StateSW swPWMorOFF(SW2); //PTC6); 
InterruptIn PWMorOFF(SW2);
// SW3
TglSW HaltSW(SW3);  //PTA4); 
DigitalIn TexSW(SW3);

//for debug
Serial pc(USBTX, USBRX); // tx, rx

void SDtex2BUF(char *filepath);

//function prototype
void SD2BUF(char *filepath);
void ifOFFseq(void);
void ifswPWM(void);
void OffSequence(void);
void DispAllDir(const char *fsrc);
void ReadBmp(const char *fsrc, uint32_t FileNum);
uint32_t CntFile(const char *fsrc);
//Grobal value
int  ifMargeTXT = 0;
int  width = 400;
int  height= 240;

float BKduty = 0;
float BKjudge = 0;
//double BKduty = 0;
float bk_timer = 1.0;
int   blduty = 0;
int   bloff = 0;
int   blctrl_sel = 0; //0:40mA, 1:160mA //Y.S
// Readed bitmap format, Color bit size = 1,4,8,(16),24,32
uint16_t bmp_bitcount;

int main() {

    uint32_t filenum=0;
    char filepath[40];
    char countup[3+1];
    char KMPH[4+1];
    
    sd.disk_initialize();
    HaltSW.Enable(1);


    FILE *fp = fopen("/sd/settings2.txt", "rb");    //read binary
    if(fp != NULL) {
        fscanf(fp, "%d",&width);     //width read
        fscanf(fp, "%d",&height);    //height read
        fscanf(fp, "%d",&blctrl_sel);//blct_sel read //0:40mA, 1:160mA
        sprintf(filepath,"/sd/%dx%d",width,height); //DispAllDir("/sd/180x180")    //file name write to filepath
        fclose(fp);  
    } else {
        FILE *fp = fopen("/sd/settings.txt", "rb");    //read binary
        if(fp != NULL) {
            fscanf(fp, "%d",&width);     //width read
            fscanf(fp, "%d",&height);    //height read
            sprintf(filepath,"/sd/%dx%d",width,height); //DispAllDir("/sd/180x180")    //file name write to filepath
            fclose(fp);  
        } else{ 
            width =180;
            height=180;
            sprintf(filepath,"/sd/180x180"); //DispAllDir("/sd/180x180")
        }
    }

  	COMSEL.write(1);    //

    BLCTRL.write(blctrl_sel);    //
    
    WD.setWH(width,height);    //input -> width, height
    WD.background(Black);      //background = black
    WD.clsBUF();               //data initialize
    WD.writeDISP();            //picture write(black)
    WD.SwDisp(1);              //disp on
    
//   OffSW.fall(&OffSequence);   // Renamed "OffSW" as "PWMorOFF" for BK PWM setting
//   SW settings for PWM or OFF
    PWMorOFF.fall(&ifswPWM);  // Backlight    //sw2 fall edge
    PWMorOFF.rise(&ifOFFseq); // OFF Sequence    //sw2 rise edge

    swPWMorOFF.Enable(8, 2, 1);  //int ModeNum, int NoiseCancel, int OpenTime    //????
    swPWMorOFF.IfCntClose(ON);
    swPWMorOFF.IfCntState(ON);

    COM60HZ.period_ms(8);    //add 20161108
    COM60HZ.write(0.5);      //add 20161108

    BK.period_ms(1);    //1ms cycle    20161012 
    BK.write(1);    //low output    20160725 <- high output

    //DIR *d;

   	while(1)
    { //BITMAPS
        filenum = CntFile(filepath);    //file number read
	   	for(uint32_t i=0; i<filenum; i++)
        {
	        for( int j = 0; j < 2; j++)
       		{
				ReadBmp(filepath,0);

  	       		 while(HaltSW.State()) {             // VCOM invert when image is still
	       	    //    pol++;
    	       	//    WD.command( (pol << 6) & 0x40 ); 
        	    //    wait(bk_timer);                       //1Hz
   	        	}
           		HaltSW.Clear();

				//1bit trasfer mode = monochro diplay
				if( j%2 == 0  && bmp_bitcount != 8)
					WD.writeDISP(TrBIT4);
				else			
					WD.writeDISP(TrBIT1);
		        //wait(2);

				if( j%2 == 0 )
				{
					// for color diaplay
			        WD.foreground(0x04);
			        WD.background(0x00);
				}else{
					// for monochrome diaplay
			        WD.foreground(0x0e);
			        WD.background(0x00);
				}
				//WD.fillrect(0,115,399,205, WD.get_Background() );

				sprintf(KMPH,"km/h");
				WD.set_ActualFontWidth();
				WD.set_font((unsigned char*) Arial28x28); 
				WD.obliqueout(70+200+35,100+20+49,KMPH);

	        	WD.set_font((unsigned char*) Arial94x94); 
				WD.set_FixedFontWidth(50);
				for(int t=0;t<100;t++)
				{
					sprintf(countup,"%2d",t);
					WD.obliqueout(70+35+48,100+20,countup);

					//1bit trasfer mode = monochro diplay
					if( j%2 == 0  /*&& bmp_bitcount != 8*/)
						// for color display
						WD.writeDISP(100+20,190+20,TrBIT4);
					else
						// for color diaplay
						WD.writeDISP(100+20,190+20,TrBIT1);

					if( j%2 == 0 && t==60)
					{
						// 60 < t => 80 yellow char
			        	WD.foreground(0x0C);
					}else
					if( j%2 == 0 && t==80)
					{
						// 80 < t => 99 rec char
			        	WD.foreground(0x08);
					}
			        //wait(0.5);
				}
		    }
        }
    }
}

/**
* @brief read a bitmap file in SD. 8color mode
*/
void SD2BUF(char *filepath){
    char R8[1],G8[1],B8[1] ,DUMMY[1],bc[2];
    int RGB;
    FILE *fp ;

  	pc.printf("file=%s\n",filepath);
    fp = fopen(filepath, "rb");
    if(fp != NULL) {
        //for(int i=0; i< 54 ; i++) fscanf(fp,"%c",DUMMY);  // Discard Header 54bytes
        for(int i=0; i< 28 ; i++) fscanf(fp,"%c",DUMMY);  // Discard Header 26bytes
        fscanf(fp,"%c",&(bc[0]));fscanf(fp,"%c",&(bc[1]));// color bit size 2bytes
        for(int i=0; i< 24 ; i++) fscanf(fp,"%c",DUMMY);  // Discard Header 26bytes
        bmp_bitcount = bc[0]+bc[1]*256;

        for(int y=height-1; y>=0; y--) {
            for(int x=0; x< width; x++) {    //24bit color  B 8bit -> G 8bit -> R 8bit
                fscanf(fp, "%c",B8);
                fscanf(fp, "%c",G8);
                fscanf(fp, "%c",R8);
                
                RGB =  RGB8(*R8,*G8,*B8);    //6bit(8bit) MIP  MASK 0000 1110
                WD.pixel(x,y,RGB);
            }
            if( y!=0)  // The last data column doesn't need padding
            for(int x=(width*3)%4; (x%4 !=0); x++) fscanf(fp, "%c",DUMMY);    // 4byte boundery for every column(only windows bitmap format)
        }
    }
    fclose(fp);
}

/**
* @brief read a text file in SD.
*/
void SDtex2BUF(char *filepath){
    int x,y,font,color;
    char text[40];
    int  ifEOF;
    FILE *fp ;

    fp = fopen(filepath, "r");
    if(fp != NULL) {
        while(ifEOF != -1){
            ifEOF = fscanf(fp,"%d,%d,%d,%d,%[^,],",&x,&y,&font,&color,text);
            WD.locate(x,y);
            WD.foreground(color);
            if      (font ==1)   WD.set_font((unsigned char*) Arial12x12);
            else if (font ==2)   WD.set_font((unsigned char*) Arial24x23); 
            else if (font ==3)   WD.set_font((unsigned char*) Arial28x28);
            else                 WD.set_font((unsigned char*) Neu42x35); 

            WD.printf("%s",text);
        }
    }
    fclose(fp);
}

/*
void DispAllDir(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    char filepath[40];
    
    while ((p = readdir(d)) != NULL)  {
        sprintf(filepath, "%s/%s",fsrc,p->d_name);
        SD2BUF(filepath);
        WD.writeDISP();
    }
    closedir(d);
}
*/

/**
* @brief read a bitmap file in SD by file number.
*/
void ReadBmp(const char *fsrc, uint32_t FileNum)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    char filepath[40];
    
    for(uint32_t i=0; i< FileNum; i++) readdir(d);
    if ((p = readdir(d)) != NULL)  {
        sprintf(filepath, "%s/%s",fsrc,p->d_name);
        SD2BUF(filepath);
        if(ifMargeTXT){
            sprintf(filepath, "%s_txt/%s.txt",fsrc,p->d_name);
            SDtex2BUF(filepath);
        }       
    }
    closedir(d);
}

uint32_t CntFile(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    uint32_t counter = 0;
    while (readdir(d)!= NULL) counter++;
    closedir(d);
    return counter;
}

void OffSequence(void){
    BK.write(0);    //add 20160712 17:00
    WD.background(Black);
    WD.clsBUF();
    WD.SwDisp(0);
    WD.writeDISP();
    WD.writeDISP();
    bloff = 1;
}

void ifswPWM(void){
    if(bloff == 0){
        if(blduty >= 10){    //0
            blduty = 0;    //10
            COMSEL.write(1);    //
        }else{
            blduty += 1;    //-=
            COMSEL.write(1);    //
        }
    }else{
        blduty = 0;
        COMSEL.write(1);    //
    }
//    BKduty =  BKduty - 0.125;
//    BKduty -= 0.125;
//    if(BKduty <= 0) BKduty = 1;
//    BK.write(BKduty);
    BK.write(blduty*0.1);     //
    if(blduty == 0){
        bk_timer = 1.0;
    }else{
        bk_timer = 0.008;    //0.016   20160712
    }
}

void ifOFFseq(void){
    if(swPWMorOFF.IfAtTime()){
        swPWMorOFF.IfCntClose(OFF);
        swPWMorOFF.IfCntState(OFF);
        OffSequence();
    }
}

