Watchdog with generalization and specialization for Freescale K64F
Tested on the FRDM K64F from Freescale
Can be specialized for any type of the processor as long as one watchdog kicker exists only

Based on hints from https://os.mbed.com/users/manitou/code/k64f_wdog/ but reworked.

Copyright (c) 2019 Waldemar Dworakowski,

/*-
 * Copyright (c) 2019 Waldemar Dworakowski,
 *
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Complete source form of any/all derivative/s and it's components must be 
 *    provided without any cost until last copy of the software (or derivative 
 *    of) exists.
 * 4. Any derivative must use same licence.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */



Usage:


#include "mbed.h"
#include "WatchDog.h"

// WatchDog
WatchDog wd;

int main(void) 
{
    wd.Start(1000); // Watchdog 1000ms
    
    printf("\r\nON - restart %d cause %4X\n\r", wd.RestartCounter(), (int)wd.RestartCause());

    while(wd.RestartCounter()<10)
    {
        ThisThread::sleep_for(200); // wait(200ms)
        wd.Kick();  // we kick the watchdog to not die if not error. On Error (or when we are not getting time from other threads) then restart.
    }

    wd.Stop();
    
    printf("\r\nOFF! %d restarts \n\r", wd.RestartCounter());

    return 0;
}
