#ifndef _WATCHDOG_H_
#define _WATCHDOG_H_

#include "WatchDog_Base.h"

/*
    Implementation of watchdog class  specialization for the Freescale K64F 
*/

/*-
 * Copyright (c) 2019 Waldemar Dworakowski,
 *
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Complete source form of any/all derivative/s and it's components must be 
 *    provided without any cost.
 * 4. Any derivative must use same licence.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


class WatchDog : WatchDog_Base
{
    public:
        WatchDog(void);
        virtual void Start(uint32_t Time_ms) ;
        virtual void Stop(void) ;
        virtual void Kick(void) ;
        virtual uint32_t RestartCounter(void);
        virtual enum RestartCauses RestartCause(void);
        virtual ~WatchDog();
    private:
        uint32_t c_SRS0;   // reset reason
        uint32_t c_SRS1;
        uint32_t c_STCTRLH;
        uint32_t c_PRESC;
        uint32_t c_TOVALL;
        uint32_t c_TOVALH;
        uint32_t c_RSTCNT;  // watchdog reset count
};

#endif
