#include "mbed.h"
#include "system_def.h"
#include "WatchDog.h"

/*
*    Implementation for FRDM-K64F
*/

/*-
 * Copyright (c) 2019 Waldemar Dworakowski,
 *
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Complete source form of any/all derivative/s and it's components must be 
 *    provided without any cost.
 * 4. Any derivative must use same licence.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

WatchDog::WatchDog(void)
{
    DoomsDayTime = 0;
    int fbus = SystemCoreClock / (((SIM->CLKDIV1 & SIM_CLKDIV1_OUTDIV2_MASK) >> SIM_CLKDIV1_OUTDIV2_SHIFT) + 1);
    int flashbus = SystemCoreClock / (((SIM->CLKDIV1 & SIM_CLKDIV1_OUTDIV4_MASK) >> SIM_CLKDIV1_OUTDIV4_SHIFT) + 1);
    
    printf("\nSystemCoreClock %d fbus %d flash %d %s %s\n",SystemCoreClock,fbus,flashbus,__TIME__,__DATE__);

    c_SRS0=RCM->SRS0;   // reset reason
    c_SRS1=RCM->SRS1;
    c_STCTRLH=WDOG->STCTRLH;
    c_PRESC=WDOG->PRESC;
    c_TOVALL=WDOG->TOVALL;
    c_TOVALH=WDOG->TOVALH;
    c_RSTCNT=WDOG->RSTCNT;
}

void WatchDog::Start(uint32_t ms) 
{
    DoomsDayTime = ms;

    __disable_irq();
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xC520); /* Key 1 */
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xD928); /* Key 2 */
    __NOP();
    __NOP();

    WDOG->TOVALL = (uint16_t)(ms & 0xffff); //  sets the time-out value
    WDOG->TOVALH = (uint16_t)((ms>>16) & 0xffff);
    WDOG->STCTRLH = (WDOG_STCTRLH_ALLOWUPDATE_MASK | WDOG_STCTRLH_WDOGEN_MASK | WDOG_STCTRLH_WAITEN_MASK | WDOG_STCTRLH_STOPEN_MASK); // Enable WDG
    WDOG->PRESC = 0; // prescaler 
    __enable_irq();
}

void WatchDog::Stop(void)  
{
    __disable_irq();
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xC520); /* Key 1 */
    WDOG->UNLOCK = WDOG_UNLOCK_WDOGUNLOCK(0xD928); /* Key 2 */
    __NOP();
    __NOP();
    WDOG->STCTRLH = WDOG_STCTRLH_ALLOWUPDATE_MASK; 
    __enable_irq();

    DoomsDayTime = 0;
}

void WatchDog::Kick(void) 
{
    if (0 == DoomsDayTime)
        return;

     __disable_irq();
    WDOG->REFRESH = 0xA602;
    WDOG->REFRESH = 0xB480;
    __enable_irq();
    return;
}

uint32_t WatchDog::RestartCounter(void)
{
    return this->c_RSTCNT;
}
    
enum WatchDog::RestartCauses WatchDog::RestartCause(void)
{
    switch(this->c_SRS0)
    {
        case 0x40:  return RESET;
        case 0x20:  return WATCHDOG;
        default:    return UNKNOWN;
    }
}
    
WatchDog::~WatchDog()
{
     if (0 != DoomsDayTime) this->Stop();
        return;
}
