#include <MemoryPool.h>
#include <RtosTimer.h>
#include <Thread.h>
#include <Queue.h>
#include <mbed.h>
#include "WaitForSwitch.h"
#include "USBHostMSD.h"
#include "Rejestrator.h"
#include "H_IO.h"
#include "Acquisition.h"
#include "FileWritter.h"

Serial pc(USBTX, USBRX);

rtos::MemoryPool<struct row_type, 20>   data_memory;
rtos::Queue<struct row_type, 20>   data_queue;

enum operating_mode_type operating_mode = Starting;

osStatus ErrorValue = osOK;

int main(void)
{
    pc.printf("Starting\n");
    rtos::Thread HIO(ThreadIO, NULL, osPriorityBelowNormal);
    pc.printf("Started IO\n");
    rtos::Thread::wait(500);
//    WaitForSwitch(Switch1, led_green);
//    rtos::Thread FileWriter(ThreadFileWritter, NULL, osPriorityNormal);
//    rtos::Thread FileWriter(ThreadFileWritter, NULL, osPriorityBelowNormal);
//    WaitForSwitch(Switch2, led_red);
    pc.printf("Starting aquisition\n");
    rtos::Thread Acquisition(ThreadAcquisition, NULL, osPriorityAboveNormal);
    pc.printf("Started aquisition\n");

    FileWritter (NULL);  
  
    pc.printf("filewriter stopped\n");

//    while (1)
//    {
//        slcd.display ((int)global_time);
//        rtos::Thread::wait(100);
//    }
}
