#include <mbed.h>
#include <MemoryPool.h>
#include <RtosTimer.h>
#include <Thread.h>
#include <Queue.h>
#include "WaitForSwitch.h"

#ifndef _REJESTRATOR_H
#define _REJESTRATOR_H

#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define SWITCH1 PTC3
  #define SWITCH2 PTC12
#else
  #error TARGET NOT DEFINED
#endif

enum operating_mode_type
{
    Starting=0,
    USB_Connecting,
    File_opening,
    Collecting,
    Waiting,
    Error,
    Exiting
};

struct row_type 
{ 
    long int time;
    int mag_x, mag_y, mag_z;
    int16_t acc_x, acc_y, acc_z;
    int16_t giro_x, giro_y, giro_z;
    float light;
    float Ain0;
    float tsi;
    int8_t temperature;
    bool was_overflow;
} ;

extern enum operating_mode_type operating_mode;

extern float global_tsi;
extern long int global_time;

#endif
