
#include "MAG3110.h"
#include "mbed.h"
/* 
 Mag regs: FF FC 5B 02 8A 0C EA C4 02 00 00 00 00 00 00 00 19 00 5F FF .
64601 650 3306

FF 
x FB B9 
y 01 21 
z 0D 44 
id C4 
System mode 02 
off x 00 00 
off y 00 00 
off z 00 00 
temp 00 
ctrl reg1 19 
ctrl reg2 00 
BF FF .
*/

/******************************************************************************
 * Constructors
 ******************************************************************************/
MAG3110::MAG3110(PinName sda, PinName scl, int i2c_adr): _i2c(sda, scl), 
    _i2c_address(i2c_adr<<1)
{ 
    begin();
}

void MAG3110::begin(void)
{
    char cmd[2];

    cmd[0] = MAG_CTRL_REG2;
    cmd[1] = MAG_3110_MAG_RST;
    _i2c.write(_i2c_address, cmd, 2);

    cmd[0] = MAG_CTRL_REG1;
    cmd[1] = MAG_3110_SAMPLE80 + MAG_3110_OVERSAMPLE3 + MAG_3110_ACTIVE;
    _i2c.write(_i2c_address, cmd, 2);
    
    cmd[0] = MAG_WHO_AM_I;
    _i2c.write(_i2c_address, cmd, 1);
    cmd[0] = 0x00;
    _i2c.read(_i2c_address, cmd, 1);
//    if (cmd[0] == MAG_3110_WHO_AM_I_VALUE)
    
    // No adjustment initially
    _avgX = 0;
    _avgY = 0;
}

// Read a single byte form 8 bit register, return as int
int MAG3110::readReg(char regAddr)
{
    char cmd[1];

    cmd[0] = regAddr;
    _i2c.write(_i2c_address, cmd, 1);

    cmd[0] = 0x00;
    _i2c.read(_i2c_address, cmd, 1);
    return (int)( cmd[0]);
}


// read a register per, pass first reg value, reading 2 bytes increments register
// Reads MSB first then LSB
int16_t MAG3110::readVal(char regAddr)
{
    char cmd[2];

    cmd[0] = regAddr;
    _i2c.write(_i2c_address, cmd, 1);

    cmd[0] = 0x00;
    cmd[1] = 0x00;
    _i2c.read(_i2c_address, cmd, 2);
    return (int)( (cmd[1]|(cmd[0] << 8))); //concatenate the MSB and LSB
}


int MAG3110::readAll(char *buffer)
{
    char cmd[2];

    cmd[0] = 0;
    _i2c.write(_i2c_address, cmd, 1);

    _i2c.read(_i2c_address, buffer, 20);
    return (int)buffer[0]; //status
}
    
float MAG3110::getHeading()
{
    int xVal = readVal(MAG_OUT_X_MSB);
    int yVal = readVal(MAG_OUT_Y_MSB);
    return (atan2((double)(yVal - _avgY),(double)(xVal - _avgX)))*180./PI;
}

void MAG3110::getValues(int *xVal, int *yVal, int *zVal)
{
    *xVal = readVal(MAG_OUT_X_MSB);
    *yVal = readVal(MAG_OUT_Y_MSB);
    *zVal = readVal(MAG_OUT_Z_MSB);
}


void MAG3110::setCalibration(int minX, int maxX, int minY, int maxY )
{
    _avgX=(maxX+minX)/2;
    _avgY=(maxY+minY)/2;
}


int8_t MAG3110::getTemperature(void)
{
    return (int8_t)readVal(MAG_DIE_TEMP);
}
