#include "Rejestrator.h"
#include "tsi_sensor.h"
#include "SLCD.h"
#include "convert.h"

#ifndef _H_IO_H
#define _H_IO_H

#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif

extern Serial pc;

extern DigitalIn Switch1;
extern DigitalIn Switch2;
extern Convert slcd;
extern TSIAnalogSlider tsi;
extern PwmOut led_green;
extern PwmOut led_red;

extern int record_counter;
extern int filenumber;
extern osStatus ErrorValue;

bool Switch_1_Pressed(void);
bool Switch_2_Pressed(void);
bool StopPressed(void);

void ThreadIO(const void *param);

class led_live
{
 public:
    led_live(const float increment_=0.1, const float minimum_=0., const float maximum_=1.);
    ~led_live();
    void live(PwmOut led);
    void speed(const float increment);
 private:
    float increment;
    const float minimum;
    const float maximum;
    float value;
};

#endif
