#include "H_IO.h"

DigitalIn Switch1(SWITCH1);
DigitalIn Switch2(SWITCH2);
Convert slcd;
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
PwmOut led_green(LED_GREEN);
PwmOut led_red(LED_RED);

float global_tsi = 0.;

led_live::led_live(const float increment_, const float minimum_, const float maximum_) :
  increment(increment_), minimum(minimum_), maximum(maximum_)
{  
    value = minimum;
}


led_live::~led_live()
{
}

void led_live::live(PwmOut led)
{
    this->value = this->value + this->increment;
    if (this->value > this->maximum) this->value = this->minimum;
    if (this->value < this->minimum) this->value = this->maximum;
    led = this->value;
}

void led_live::speed(const float increment_)
{
    this->increment = increment_;
}


void RunningTSI(const void *param)
{
    if (operating_mode != Exiting)
    {
        global_tsi = tsi.readPercentage();
    }
}

bool Switch_1_Pressed(void)
{
    return (Switch2.read() == 0);
}


bool Switch_2_Pressed(void)
{
    return (Switch2.read() == 0);
}


bool StopPressed(void)
{
    return (Switch_2_Pressed() || (operating_mode == Exiting));
}


void ThreadIO(const void *param)
{
    char RunBuffer[5];

    led_red = 1.;
    led_green = 1.;

    rtos::RtosTimer TSI(RunningTSI, osTimerPeriodic, NULL);
    TSI.start(100);

    while (operating_mode != Exiting)
    {
        switch (operating_mode) 
        {
            case Starting:
                slcd.display("====");
                break;
            case USB_Connecting:
                slcd.display("USB");
                break;
            case File_opening:
                slcd.display("OPEN");
                break;
            case Collecting:
                sprintf(RunBuffer, "F%3d", filenumber);
                slcd.display(RunBuffer);
                rtos::Thread::wait(500);
                slcd.display(record_counter);
                rtos::Thread::wait(500);
                if (Switch1.read() == 0) 
                {
                    operating_mode = Waiting;
                    while (Switch1.read() == 0) 
                    {
                        rtos::Thread::wait(100);
                    }
                }
                break;
            case Waiting:
                slcd.display("WAIT");
                if (Switch1.read() == 0) 
                {
                    operating_mode = Collecting;
                    while (Switch1.read() == 0) 
                    {
                        rtos::Thread::wait(100);
                    }
                }
                break;
            case Error:
                slcd.display((int)ErrorValue);
                led_red = 1;
                led_green = 0.5;
                break;
            case Exiting:
                slcd.display("=00=");
                break;
        }
        
        if (Switch2.read() == 0) 
            operating_mode = Exiting;

        rtos::Thread::wait(100);
    }

    TSI.stop();
    
    slcd.display("END ");
}
