#include "FileWritter.h"

int record_counter = 0;
int filenumber = 0;
led_live writter_led(0.01, 0.5, 1.);

void FileWritter(const void *param)
{
    USBHostMSD* msd = new USBHostMSD("usb");
    FILE *ft = NULL;

    led_red = 1.;

    operating_mode = Collecting;
//    pc.printf("Starting USB\n");

    while (operating_mode != Exiting)
    {
        led_red = 0.0;
        if (!msd->connected())
        {
        // try to connect a MSD device
            while((!msd->connect()) && (operating_mode != Exiting))
            {
                rtos::Thread::wait(500);
//                operating_mode = USB_Connecting;
            }
        }
        
        led_red = 1.;

        while (ft == NULL)
        {
            char filetrgt[25];
            
            if (operating_mode == Exiting)
                return;
                
            led_red = 0.0;
            sprintf(filetrgt, "/usb/R/R%07d.csv", ++filenumber);
            pc.printf("Opening file %s\n", filetrgt);
            ft = fopen(filetrgt, "rb");
            if (ft == NULL)
            {
                ft = fopen(filetrgt, "wb");
                if (ft == NULL) 
                {
//                    operating_mode = File_opening;
                } 
            }
            else
            {
                led_red = 1.0;
                fclose (ft);
                ft = NULL;
            }
        }

        led_red = 1;
        operating_mode = Collecting;

        for (record_counter=0; ((record_counter < FILESIZE) && (operating_mode != Exiting)); ++record_counter)
        {
            osEvent queue_returned;

            if ((ft != NULL) && (record_counter == 0))
                fprintf(ft, "File\tTime\tnr\tmag_X\tmag_Y\tmag_z\tacc_X\tacc_Y\tacc_Z\tgiro_X\tgiro_Y\tgiro_Z\tlight\tAin0\tTSI\tTemperature\toverflow\t\n");

            do
            {
                queue_returned = data_queue.get(20);
            } while ((queue_returned.status != osEventMessage) && (operating_mode != Exiting));

            struct row_type *data_buffer = (struct row_type *)queue_returned.value.p;

            if (ft != NULL)
            {
                fprintf(ft, "%8d\t%12d\t%5d\t%6d\t%6d\t%6d\t%6d\t%6d\t%6d\t%6d\t%6d\t%6d\t%6.4f\t%6.4f\t%6.3f\t%5d\t%1d\t\n", 
                        (int)filenumber, (int)data_buffer->time, (int)record_counter, 
                        (int)data_buffer->mag_x, (int)data_buffer->mag_y, (int)data_buffer->mag_z, 
                        (int)data_buffer->acc_x, (int)data_buffer->acc_y, (int)data_buffer->acc_z,
                        (int)data_buffer->giro_x, (int)data_buffer->giro_y, (int)data_buffer->giro_z,
                        (float)data_buffer->light, (float)data_buffer->Ain0, 
                        (float)data_buffer->tsi, 
                        (int)data_buffer->temperature,
                        (int)data_buffer->was_overflow);
                fflush(ft);
            }
            data_memory.free(data_buffer);
            writter_led.live(led_red);
        }
        
        if (NULL != ft)
        { 
            fflush(ft);
            fclose(ft);
            ft=NULL;
        }
        fflush(NULL);
    }
    
    pc.printf("Ending file writing task\n");

    for (int i=0; i<10; ++i)
    {
        led_red = 0.9;
        rtos::Thread::wait(200);
        led_red = 0.1;
        rtos::Thread::wait(400);
    }
    led_red = 1.0;
}
