#include "convert.h"

/*-------------------------------------------------------------

(c) W.D. 2014

-------------------------------------------------------------*/

Convert::Convert()
{
    this->prepare();
   
    return;
}

void Convert::prepare(void)
{
    this->blink(-1); 
    this->clear();
    this->DP1(0);
    this->DP2(0);
    this->DP3(0);
    this->Colon(0);
    this->Home();
    
    return;
}

void Convert::display_digits(unsigned int number, bool negate)
{
    register unsigned short int c1 = ((unsigned int) number / 1000);
    register unsigned short int c2 = ((unsigned int) number / 100) - (c1 * 10);
    register unsigned short int c3 = ((unsigned int) number / 10) - ((c1 *100) + (c2 *10));
    register unsigned short int c4 = number - ((c1 *1000) + (c2 *100) + (c3 *10));
    
    this->blink(-1); 
    this->Home();
    if (negate)
        this->putc('-');
    else
        this->putc('0'+c1);
    this->putc('0'+c2);
    this->putc('0'+c3);
    this->putc('0'+c4);
    
    return;
}

bool Convert::display(unsigned int number)
{
    this->DP1(false);
    this->DP2(false);
    this->DP3(false);
    this->Colon(false);

    if (number > 9999)
    {
        this->blink(2); 
        this->display(" OFL");
        return true;
    }
    else
    {
        this->display_digits(number); 
        return false;
    }
}

bool Convert::display(int number)
{
    this->DP1(false);
    this->DP2(false);
    this->DP3(false);
    this->Colon(false);

    if (number < 0)
    {
        if (number < -999)
        {
            this->blink(3); 
            this->display("-OFL");
            return true;
        }
        else
        {
            this->display_digits ((unsigned int) -number, true);
            return false;
        }
    }
    else if (number > 9999)
    {
        this->blink(3); 
        this->display(" OFL");
        return true;
    }
    else
    {
        this->display_digits ((unsigned int) number, false);
        return false;
    }
}

bool Convert::display(double number)
{
    this->Colon(false);
// >=10000   OVL
    if (number >= 10000.)
    {
        this->blink(3); 
        this->display(" OFL");
        return true;
    }
// >=1000   1234
    else if (number >= 1000.)
    {
        this->DP1(false);
        this->DP2(false);
        this->DP3(false);
        this->display_digits ((unsigned int) number);
        return false;
    }
// >=100    123.4
    else if (number >= 100.)
    {
        this->DP1(false);
        this->DP2(false);
        this->DP3(true);
        this->display_digits ((unsigned int) (number*10.));
        return false;
    }
// >=10     12.34
    else if (number >= 10.)
    {
        this->DP1(false);
        this->DP2(true);
        this->DP3(false);
        this->display_digits ((unsigned int) (number*100.));
        return false;
    }
// >=0      1.234
    else if (number >= 0.)
    {
        this->DP1(true);
        this->DP2(false);
        this->DP3(false);
        this->display_digits ((unsigned int) (number*1000.));
        return false;
    }
// <0
// <=-1     -1.23
    else if (number >= -10.)
    {
        this->DP1(false);
        this->DP2(true);
        this->DP3(false);
        this->display_digits ((unsigned int) (number*-100.), true);
        return false;
    }
// <=-10    -12.3
    else if (number >= -100.)
    {
        this->DP1(false);
        this->DP2(false);
        this->DP3(true);
        this->display_digits ((unsigned int) (number*-10.), true);
        return false;
    }
// <=-100   -123
    else if (number >= -1000.)
    {
        this->DP1(false);
        this->DP2(false);
        this->DP3(false);
        this->display_digits ((unsigned int) (-number), true);
        return false;
    }
    else
// <=-1000  -OVL
    {
        this->blink(3); 
        this->display("-OFL");
        return true;
    }
       
}

bool Convert::display(float number)
{
    return this->display((double) number);
}

bool Convert::display(char *text)
{
    this->DP1(false);
    this->DP2(false);
    this->DP3(false);
    this->Colon(false);
    this->Home();
    for(int i=0; i<4; i++)
    {
        if (text[i]==0) 
            break; 
        else 
            this->putc(text[i]);
    }
    return false;
}
