#include "Rejestrator.h"
#include "H_IO.h"
#include "MMA8451Q.h"
#include "MAG3110.h"

#ifndef _ACQUISITION_H
#define _ACQUISITION_H

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  const PinName SDA = PTE25;
  const PinName SCL = PTE24;
#elif defined (TARGET_KL05Z)
  const PinName SDA = PTB4;
  const PinName SCL = PTB3;
#elif defined (TARGET_K20D50M)
  const PinName SDA = PTB1;
  const PinName SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

const int MMA8451_I2C_ADDRESS = (0x1d<<1);

extern bool was_overflow;

extern struct row_type last_measurement;

extern rtos::MemoryPool<struct row_type, 20>   data_memory;
extern rtos::Queue<struct row_type, 20>   data_queue;

void ThreadAcquisition(const void *param);
void RunningAcquisition(const void *param);

#endif