#include "Acquisition.h"

AnalogIn light(PTE22);
AnalogIn Ain0(PTE20);
AnalogOut Aout(PTE30);
MAG3110 mag(SDA, SCL);
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

long int global_time = 0;
bool was_overflow = false;
struct row_type last_measurement;

led_live aquisition_led(0.01, 0.5, 1.);

void RunningTimer(const void *param)
{
    if (operating_mode != Exiting)
    {
        ++global_time;
    }
}

void RunningAcquisition(const void *param)
{
    osStatus put_result;
    if (operating_mode == Collecting)
    {
        struct row_type *data_buffer = data_memory.alloc();

//        mag.getValues(&data_buffer->mag_x, &data_buffer->mag_y, &data_buffer->mag_z);
        data_buffer->mag_x = (int)mag.readVal(MAG_OUT_X_MSB);
//        (int)((int16_t)data_buffer->mag_x);
        data_buffer->mag_y = (int)mag.readVal(MAG_OUT_Y_MSB);
//        (int)((int16_t)data_buffer->mag_y);
        data_buffer->mag_z = (int)mag.readVal(MAG_OUT_Z_MSB);
//        (int)((int16_t)data_buffer->mag_z);
        
        data_buffer->giro_x = 0;
        data_buffer->giro_y = 0;
        data_buffer->giro_z = 0;

        data_buffer->acc_x = acc.getAccX_int();
        data_buffer->acc_y = acc.getAccY_int();
        data_buffer->acc_z = acc.getAccZ_int();

        data_buffer->light = light.read();
        data_buffer->Ain0 = Ain0.read();

        data_buffer->temperature = mag.getTemperature();

        data_buffer->tsi = global_tsi;

        data_buffer->time = global_time;
        data_buffer->was_overflow = was_overflow;
        
        put_result = data_queue.put(data_buffer, 10);
        last_measurement = *data_buffer;
        switch (put_result)
        {
            case osOK:
            case osEventMessage:
                was_overflow = false;
                break;
            case osEventTimeout:
                was_overflow = true;
                data_memory.free(data_buffer);
                break;
        }
        aquisition_led.live(led_green);
    }
}

void ThreadAcquisition(const void *param)
{
    led_green = 1.;

    rtos::RtosTimer timer(RunningTimer, osTimerPeriodic, NULL);
    rtos::RtosTimer Acquisition(RunningAcquisition, osTimerPeriodic, NULL);
/*
    // debug
    {
        extern Serial pc;
        pc.printf("\nMag regs: ");
        for (int i=0; i<20; ++i)
        {
            pc.printf("%02X ", mag.readReg(i));
        }
        pc.printf(".\n");
        for (int i=0; i<1000; ++i)
        {
            pc.printf("%d %d %d \n", mag.readVal(MAG_OUT_X_MSB), mag.readVal(MAG_OUT_Y_MSB), mag.readVal(MAG_OUT_Z_MSB));
        }
    } 
*/
    timer.start(1); 
    Acquisition.start(100);

    while (operating_mode != Exiting)
    {
        rtos::Thread::wait(100);
    }

    rtos::Thread::wait(200); // free the waif for buffer
    Acquisition.stop();
    timer.stop();

    for (int i=0; i<10; ++i)
    {
        led_green = 0.9;
        rtos::Thread::wait(100);
        led_green = 0.1;
        rtos::Thread::wait(100);
    }
    led_green = 1.;
}

