#include "mbed.h"
#include "nRF24L01P.h"

/* Dokumentacja do modulu nrf24l01*/
/* https://www.nordicsemi.com/eng/nordic/download_resource/8765/2/75557853/2726 */

//***************************************************************************//
// !!! SETTINGS !!!

#define DATA_RATE       NRF24L01P_DATARATE_250_KBPS    
//#define DATA_RATE       NRF24L01P_DATARATE_1_MBPS     
//#define DATA_RATE       NRF24L01P_DATARATE_2_MBPS    

#define POWER           NRF24L01P_TX_PWR_ZERO_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_6_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_12_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_18_DB

#define CHANNEL         0 // 0 - 30


#define RX_ADDRESS      ((unsigned long long) 0xABCDEF01)
#define TX_ADDRESS      ((unsigned long long) 0xABCDEF00)
#define ECHO_DELAY      0.1

#define TRANSFER_SIZE   32

//***************************************************************************//



Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P radio(PB_15, PB_14, PB_13, PB_12, PB_1, PB_2);    // mosi, miso, sck, csn, ce, irq


DigitalOut myled1(LED1);
InterruptIn button(USER_BUTTON);

bool send_data = false;

void send_packet(){
    send_data = true;
}

int main() {

    
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];

    pc.baud(115200);
    radio.powerDown();
    radio.powerUp();
    
    button.rise(&send_packet);
    
    radio.setAirDataRate(DATA_RATE);
    radio.setRfOutputPower(POWER);
    radio.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY + 4 * CHANNEL);
    
    radio.setCrcWidth(NRF24L01P_CRC_8_BIT);
    //radio.enableAutoAcknowledge(NRF24L01P_PIPE_P0);
    //radio.enableAutoAcknowledge(NRF24L01P_PIPE_P1);
    //radio.enableAutoRetransmit(0x0F, 0x0F);
    
    radio.setTxAddress(TX_ADDRESS, 4);
    radio.setRxAddress(TX_ADDRESS, 4, NRF24L01P_PIPE_P0);
    radio.setRxAddress(RX_ADDRESS, 4, NRF24L01P_PIPE_P1);
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  radio.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  radio.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", radio.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", radio.getTxAddress() );
    pc.printf( "nRF24L01+ RX0 Address   : 0x%010llX\r\n", radio.getRxAddress(NRF24L01P_PIPE_P0) );
    pc.printf( "nRF24L01+ RX1 Address   : 0x%010llX\r\n", radio.getRxAddress(NRF24L01P_PIPE_P1) );


    radio.setTransferSize(TRANSFER_SIZE, NRF24L01P_PIPE_P0);
    radio.setTransferSize(TRANSFER_SIZE, NRF24L01P_PIPE_P1);
    
    myled1 = 0;

    radio.enableDynamicPayload(NRF24L01P_PIPE_P1);
    radio.setReceiveMode();
    radio.enable();

    while (1) {
        int tx_bytes=0;
        int rx_bytes=0;

        if(radio.readable(NRF24L01P_PIPE_P1)){

            rx_bytes = radio.read(NRF24L01P_PIPE_P1, rxData, sizeof(rxData));
            myled1 = 1;
            pc.printf("PING RECV[%d]\r\n", rx_bytes);
            
            wait(ECHO_DELAY);
            
            tx_bytes = radio.write(NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE);
            myled1 = 0;
            pc.printf("PONG SEND\r\n");
        }

        
        if(send_data){
            tx_bytes = radio.write(NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE);
            send_data = false;
            pc.printf("INIT SEND\r\n");
        }
        
        if(tx_bytes < 0)
            pc.printf("TX ERROR\r\n");
            
        if(tx_bytes > 0)    
            pc.printf("RETR: %d\r\n", radio.getRetrCount());
        
    }
}
