#include "mbed.h"
#include "nRF24L01P.h"

//***************************************************************************//
// !!! SETTINGS !!!

#define DATA_RATE       NRF24L01P_DATARATE_250_KBPS    
//#define DATA_RATE       NRF24L01P_DATARATE_1_MBPS     
//#define DATA_RATE       NRF24L01P_DATARATE_2_MBPS    

#define POWER           NRF24L01P_TX_PWR_ZERO_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_6_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_12_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_18_DB

#define CHANNEL         0 // 0 - 30


#define RX_ADDRESS      ((unsigned long long) 0xABCDEF02)
#define TX_ADDRESS      ((unsigned long long) 0xABCDEF00)
#define ECHO_DELAY      0.2

#define TRANSFER_SIZE   1

//***************************************************************************//



Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P radio(PB_15, PB_14, PB_13, PB_12, PB_1, PB_2);    // mosi, miso, sck, csn, ce, irq


DigitalOut myled1(LED1);
InterruptIn button(USER_BUTTON);

bool send_data = false;

void send_packet(){
    send_data = true;
}

int main() {

    
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];

    pc.baud(115200);
    radio.powerDown();
    radio.powerUp();
    
    button.rise(&send_packet);
    
    radio.setAirDataRate(DATA_RATE);
    radio.setRfOutputPower(POWER);
    radio.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY + 4 * CHANNEL);
    radio.setRxAddress(RX_ADDRESS, 4);
    radio.setTxAddress(TX_ADDRESS, 4);
    radio.setCrcWidth(NRF24L01P_CRC_8_BIT);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  radio.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  radio.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", radio.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", radio.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", radio.getRxAddress() );


    radio.setTransferSize( TRANSFER_SIZE );
    
    myled1 = 0;

    radio.setReceiveMode();
    radio.enable();

    while (1) {
        int tx_bytes;
        int rx_bytes;

        if(radio.readable()){

            rx_bytes = radio.read(NRF24L01P_PIPE_P0, rxData, sizeof(rxData));
            myled1 = 1;
            
            wait(ECHO_DELAY);
            
            tx_bytes = radio.write(NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE);
            myled1 = 0;
        }
        
        if(send_data){
            tx_bytes = radio.write(NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE);
            send_data = false;
        }
        
    }
}
