#include "mbed.h"
#include "nRF24L01P.h"


//***************************************************************************//
// !!! SETTINGS !!!

#define DATA_RATE       NRF24L01P_DATARATE_250_KBPS    
//#define DATA_RATE       NRF24L01P_DATARATE_1_MBPS     
//#define DATA_RATE       NRF24L01P_DATARATE_2_MBPS    

#define POWER           NRF24L01P_TX_PWR_ZERO_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_6_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_12_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_18_DB

#define CHANNEL         0 // 0 - 30

//***************************************************************************//


Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P radio(PB_15, PB_14, PB_13, PB_12, PB_1, PB_2);    // mosi, miso, sck, csn, ce, irq
DigitalOut led(LED1);
InterruptIn button(USER_BUTTON);

bool send_data = false;
long tx_packet_counter = 0;
long tx_bit_counter = 0;
bool status = false;


void tick_status(){
    status = true;
}

void print_status(){
    char buff[128];
    
    sprintf(buff, "TX status: %d\r\n"
                  "TX packets num: %ld\r\n"
                  "TX bits num:    %ld\r\n\r\n", send_data, tx_packet_counter, tx_bit_counter);
    
    pc.write((const uint8_t *)buff, strlen(buff), 0, 0);
}
    
void onoff(){
    if(send_data == false){
        send_data = true;
        led = 1;
    } else {
        send_data = false;
        led = 0;
    }
}

int main() {
    #define TRANSFER_SIZE   32
    #define CODE 0xAA
    char txData[TRANSFER_SIZE];
    Ticker status_ticker;
    

    for(int i=0; i<TRANSFER_SIZE;i++){
        txData[i] = CODE;
    }
    
    status_ticker.attach(&tick_status, 1.0);
    button.rise(&onoff);
    pc.baud(115200);
    
    radio.powerDown();
    radio.powerUp();
    
    radio.setAirDataRate(DATA_RATE);
    radio.setRfOutputPower(POWER);
    radio.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY + 4 * CHANNEL);
    
    radio.setTransferSize(TRANSFER_SIZE);
    radio.setCrcWidth(NRF24L01P_CRC_NONE);
    
    pc.printf( "=======================================\r\n");
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  radio.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  radio.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", radio.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", radio.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", radio.getRxAddress() );
    pc.printf( "=======================================\r\n");


    while(1){
        
        if(send_data){  
            int tx_bytes;
            
            tx_bytes = radio.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE);
            
            if(tx_bytes < 0){
                pc.printf("TX ERROR!\r\n");
            } else{
                tx_packet_counter += 1;
                tx_bit_counter += tx_bytes * 8; 
            }
        }
        
        if(status){
            print_status();
            status = false;
        }
    }
}
