#include "mbed.h"
#include "nRF24L01P.h"


//***************************************************************************//
// !!! SETTINGS !!!

#define DATA_RATE       NRF24L01P_DATARATE_250_KBPS    
//#define DATA_RATE       NRF24L01P_DATARATE_1_MBPS     
//#define DATA_RATE       NRF24L01P_DATARATE_2_MBPS    

#define POWER           NRF24L01P_TX_PWR_ZERO_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_6_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_12_DB
//#define POWER           NRF24L01P_TX_PWR_MINUS_18_DB

#define CHANNEL         0 // 0 - 30

//***************************************************************************//


Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P radio(PB_15, PB_14, PB_13, PB_12, PB_1, PB_2);    // mosi, miso, sck, csn, ce, irq
DigitalOut led(LED1);
InterruptIn button(USER_BUTTON);

bool stats_reset = false;
long rx_packet_counter = 0;
long rx_bit_counter = 0;
long rx_error_counter = 0;
bool status = false;


void tick_status(){
    status = true;
}

void print_status(){
    char buff[256];
    
    sprintf(buff, "RX packets num: %ld\r\n"
                  "RX bits num:    %ld\r\n"
                  "RX errors:      %ld\r\n\r\n",
            rx_packet_counter, rx_bit_counter, rx_error_counter);
    
    pc.write((const uint8_t *)buff, strlen(buff), 0, 0);
}
    
void rst_stats(){
    stats_reset = true;   
}

int main() {
    #define TRANSFER_SIZE   32
    #define CODE 0xAA
    char rxData[TRANSFER_SIZE];
    Ticker status_ticker;
           
    radio.powerDown();
    radio.powerUp();
    
    radio.setAirDataRate(DATA_RATE);
    radio.setRfOutputPower(POWER);
    radio.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY + 4 * CHANNEL);
    
    radio.setTransferSize(TRANSFER_SIZE);
    radio.setCrcWidth(NRF24L01P_CRC_NONE);
    
    pc.baud(115200);
    status_ticker.attach(&tick_status, 1.0);
    button.rise(&rst_stats);
    
    
    pc.printf( "=======================================\r\n");
    pc.printf( "CPU SystemCoreClock is : %d Hz\r\n", SystemCoreClock);  
    pc.printf( "=======================================\r\n");
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  radio.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  radio.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", radio.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", radio.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", radio.getRxAddress() );
    pc.printf( "=======================================\r\n");

    radio.setReceiveMode();
    radio.enable();

    while(1){
    
        if(radio.readable()){  
            int rx_bytes;
            
            rx_bytes = radio.read( NRF24L01P_PIPE_P0, rxData, sizeof(rxData));
            
            if(rx_bytes < 0){
                pc.printf("RX ERROR!\r\n");
            } else{
                rx_packet_counter += 1;
                rx_bit_counter += rx_bytes * 8; 
                
                for(int i=0; i<rx_bytes; i++){
                    int err_bits;
                    if(rxData[i] != CODE){
                        err_bits = rxData[i] xor CODE;
                        rx_error_counter += __builtin_popcount(err_bits);
                    }
                } 
            }
        }
        
        if(stats_reset){
            pc.printf("=== RESETING COUNTERS ===\r\n");
            rx_packet_counter = 0;
            rx_bit_counter = 0;
            rx_error_counter = 0;
            stats_reset = false;
        }
        
        if(status){
            print_status();
            status = false;
        }
    }
}
