/*
I know the quality of the code is terrible, but we had to throw everything together
quickly because of technical difficulties...
*/
#include "mbed.h"
//Pro tip: The TextLCD.h file contains #defines for choosing I2C adapter mappings.
#include "TextLCD.h"
#include "custom-chars.h"
#include "melodies.h"
#include "nRF24L01P.h"
#include <string>
#include <vector>

time_t next_alarm = 0;

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

I2C i2c_lcd(D5,D7); // SDA, SCL pins. Change if necessary
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2); // I2C exp: I2C bus, PCF8574 Slaveaddress, LCD Type

//Light sensor
#define LIGHT_INTERVAL 2
AnalogIn light_sensor(A1);
double light_sum;
int light_samples;
time_t next_light = 0;

void lightSensor(){
    light_sum += light_sensor.read();
    light_samples++;
    //TODO: setting up a callback to do this would be a better idea
    next_light = time(NULL) + LIGHT_INTERVAL;
}

//Handling display
void backlightTimeout();
Timeout backlightTimer;

class Display{
public:
    int wifi_on;
    int alarm_on;
    int sync_in_progress;
    int sync_failed;
    int wireless_in_progress;
    int frame;
    
    time_t seconds;
    char time_str[9];
    char date_str[11];
    
    static const float backlightTime = 5.0;
    int backlightState;
    Display()
    {
        wifi_on = 0;
        alarm_on = 0;
        sync_in_progress = 0;
        sync_failed = 0;
        wireless_in_progress = 0;
        frame = 0;
        backlightState = 0;
        
        lcd.setCursor(TextLCD::CurOff_BlkOff);
        lcd.setUDC(C_ALRM, cc_dzwonek);
        lcd.setUDC(C_WIFI, cc_wifi);
        lcd.setUDC(C_WLC , cc_wireless);
    }
    
    void backlightOff(){
        lcd.setBacklight(TextLCD::LightOff);
        backlightState = 0;
    }
    
    void backlightOn(bool permanent = false){
        lcd.setBacklight(TextLCD::LightOn);
        backlightState = 1;
        if (!permanent){
            backlightTimer.attach(&backlightTimeout, backlightTime);
        }
        
    }
    
    void update(){
        //TODO: refresh the screen only if something changes, there's no reason to do it all the time
        //Top row of display
        char ico1 = ' ';
        char ico2 = sync_in_progress ? C_WIFI : ' ';
        char ico3 = ' ';
        char alarm_time[6];
        if (wireless_in_progress){
            ico1 = frame % 2 ? C_WLC : ' ';
            wireless_in_progress--;
        }
               
        time_t seconds_now = time(NULL);
        if (seconds_now != seconds) {
            seconds = seconds_now;
            strftime(time_str, 9, "%X", localtime(&seconds));
            strftime(date_str, 11, "%F", localtime(&seconds));
        }
        
        if (next_alarm != 0){
            ico3 = C_ALRM;
            if (next_alarm > seconds_now && next_alarm - seconds_now > 24*60*60){
                //If the alarm is later than 24 hours from now, display date
                strftime(alarm_time, 6, "%m-%d", localtime(&next_alarm));
            }
            else {
                //If the alarm is within 24 hours, display hour and minute
                strftime(alarm_time, 6, "%H:%M", localtime(&next_alarm));
            }
        }
        else {
            strcpy(alarm_time, "     ");
        }
        
        lcd.locate(0,0); //Put in top row
        lcd.printf("%8s%c%c%c%5s",time_str,ico1,ico2,ico3,alarm_time);
        
        //Bottom row of display
        lcd.locate(0,1); //Put in bottom row
        if (sync_in_progress) {
            lcd.printf("Synchronizacja..");
        }
        else if (sync_failed){
            lcd.printf("Blad synchroniz.");
            sync_failed--;
        }
        else if (alarm_on){
            lcd.printf("Wstawaj!        ");
        }
        else {
            if (frame % 60 < 30) {
                lcd.printf(" SmartAlarm Pro ");
            }
            else {
                lcd.printf("   %10s   ", date_str);
            }
        }
        frame++;
    }
};

Display disp;

//2.4 GHz radio
#define RX_ADDRESS      ((unsigned long long) 0xABCDEF00)
#define TX_ADDRESS      ((unsigned long long) 0xABCDEF01)
#define TRANSFER_SIZE   32

nRF24L01P radio(PB_15, PB_14, PB_13, PB_12, PB_1, PB_2);

void initRadio(int channel, int power, int datarate){    
    radio.powerDown();
    radio.powerUp();
    
    radio.setAirDataRate(datarate);
    radio.setRfOutputPower(power);
    radio.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY + 4 * channel);
    
    radio.setCrcWidth(NRF24L01P_CRC_8_BIT);
    radio.enableAutoAcknowledge(NRF24L01P_PIPE_P0);
    radio.enableAutoAcknowledge(NRF24L01P_PIPE_P1);
    radio.enableAutoRetransmit(0x0F, 0x0F);
    
    radio.setTxAddress(TX_ADDRESS, 4);
    radio.setRxAddress(TX_ADDRESS, 4, NRF24L01P_PIPE_P0);
    
    radio.setRxAddress(RX_ADDRESS, 4, NRF24L01P_PIPE_P1);
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  radio.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  radio.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", radio.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", radio.getTxAddress() );
    pc.printf( "nRF24L01+ RX0 Address   : 0x%010llX\r\n", radio.getRxAddress(NRF24L01P_PIPE_P0) );
    pc.printf( "nRF24L01+ RX1 Address   : 0x%010llX\r\n", radio.getRxAddress(NRF24L01P_PIPE_P1) );


    radio.setTransferSize(TRANSFER_SIZE, NRF24L01P_PIPE_P0);
    radio.setTransferSize(TRANSFER_SIZE, NRF24L01P_PIPE_P1);

    radio.setReceiveMode();
    radio.enable();
};

bool movement_detected = false;

std::vector<std::string> last_wireless_data;
time_t last_wireless_time;

//TODO: average the data, not just keep the last value!
double last_min = 0, last_max = 0, last_avg = 0, last_temp = 0;

void processWirelessData(char* data_string){
    std::string s = data_string;
    std::vector<std::string> data;
    size_t pos = 0;
    std::string token;
    std::string delimiter = ";";
    
    while ((pos = s.find(delimiter)) != std::string::npos) {
        token = s.substr(0, pos);
        data.push_back(token);
        s.erase(0, pos + delimiter.length());
    }
    
    last_wireless_data = data;
    last_wireless_time = time(NULL);
    
    pc.printf("data %d\r\n",data.size());
    if (data.size() >= 3){
        last_min = atof(data[0].c_str());
        last_max = atof(data[1].c_str());
        last_avg = atof(data[2].c_str());
        
        //TODO: Hardcoded values based on educated guessing
        if (last_max > 0.6 && last_avg > 0.2){
            pc.printf("moved\r\n");
            movement_detected = true;
        }
        else{
            pc.printf("not moved\r\n");
            movement_detected = false;
        }
    }
    if (data.size() >= 4){
        last_temp = atof(data[3].c_str());
    }
}

void radio_recv(){
    char rxData[TRANSFER_SIZE+1];
    int rx_bytes=0;
    
    if(radio.readable(NRF24L01P_PIPE_P1)){
        disp.wireless_in_progress = 10; //Message will be displayed for 10 frames
        rx_bytes = radio.read(NRF24L01P_PIPE_P1, rxData, TRANSFER_SIZE);
        rxData[TRANSFER_SIZE] = '\0';
        pc.printf("Received %d >>%s<<\r\n",rx_bytes, rxData);
        processWirelessData(rxData);
    }
}

//Handling user button presses
InterruptIn button(D6);
int userButtonLongPress = 300; //Time in ms; threshold for long press
Timer userButtonTimer;

int userButtonPressed = 0, userButtonReleased = 0, backlightTimedOut = 0;

void userButtonPress(){
    userButtonPressed = 1;   
}

void userButtonRelease(){
    userButtonReleased = 1; 
}

void backlightTimeout(){
    backlightTimedOut = 1;
}

//Wi-Fi communication
#define WIFI_SIZE 1000
Serial wifi(PA_9, PA_10);
char wifiData[WIFI_SIZE];
bool wifiDataReady = false;
bool readInProgress = false;
int currentReadIndex = 0;

//Expects a response to start with "*" and end with another "*"
//Ignores characters that are not between them
void wifiCallback() {
    char c = wifi.getc();
    
    if (c == '*') {
        readInProgress = !readInProgress;
        wifiData[currentReadIndex] = '\0';
        currentReadIndex = 0;
        if (readInProgress == false)
            wifiDataReady = true;
    } else if (readInProgress) {
        wifiData[currentReadIndex++] = c;
    }
}

std::string wifiGetData(){
    if (!wifiDataReady)
        return "";
        
    std::string result = wifiData;
    wifiDataReady = false;
    return result;
}

//TODO: There has to be a better way to make those requests,
//but I don't have time to figure it out
std::string httpGETWithRetry(const char* query, float timeout, int retries){
    Timer t;
    for (int retry = 0; retry<retries; retry++){
        wifi.printf(query);
        t.reset();
        t.start();
        while (!wifiDataReady && t <= timeout){
            wait(0.1f);
        }
        
        pc.printf("http GET trying #%d\r\n", retry);
        if (wifiDataReady)
            break;
    }
    return wifiGetData();
}

//Synchronization
time_t next_sync = 0;
time_t last_sync = 0;
bool sync_in_progress = false;

time_t getNextSync(){
    return time (NULL) + 45; //TODO: synchronization hardcoded to every 45 seconds
}

//TODO: hardcoded HTTP requests, argh
int syncFunction(){
    disp.sync_in_progress = 1;
    last_sync = time(NULL);
    std::string time_string = httpGETWithRetry("GET " 
                "/time/current "
                "HTTP/1.1\r\n"
                "Host: 10.1.8.202:8080\r\n\r\n", 2.0, 5);
    if (time_string == ""){
        disp.sync_failed = 10;
    }
    else {
        set_time(atoi(time_string.c_str()));
    }
    
    time_string = httpGETWithRetry("GET " 
                "/alarm/get/nearest/id/58362c0bd0d41f4f91240f29 "
                "HTTP/1.1\r\n"
                "Host: 10.1.8.202:8080\r\n\r\n", 2.0, 5);
    if (time_string == ""){
        disp.sync_failed = 10;
    }
    else {
        next_alarm = atoi(time_string.c_str());
    }
    
    //Get light sensor data
    double light_sensor_avg;
    light_sensor_avg = light_samples == 0 ? 0 : light_sum / light_samples ;
    light_sum = 0;
    light_samples = 0;
    
    wifi.printf("POST " 
                "/statistics/value/%f/device_id/58362c0bd0d41f4f91240f29/type/light "
                "HTTP/1.1\r\n"
                "Host: 10.1.8.202:8080\r\n\r\n"
                "\r\n\r\n", light_sensor_avg);
                
    if (last_temp != 0.0){
        wifi.printf("POST " 
                "/statistics/value/%f/device_id/58362c0bd0d41f4f91240f29/type/temperature "
                "HTTP/1.1\r\n"
                "Host: 10.1.8.202:8080\r\n\r\n"
                "\r\n\r\n", last_temp);
        last_temp = 0;
    }
    if (last_max != 0.0){
        wifi.printf("POST " 
                "/statistics/value/%f/device_id/58362c0bd0d41f4f91240f29/type/movement_max "
                "HTTP/1.1\r\n"
                "Host: 10.1.8.202:8080\r\n\r\n"
                "\r\n\r\n", last_max);
        last_max = 0.0;
    }
    next_sync = getNextSync();
    return 0;
}

//Alarm
PwmOut sound(D12);
bool alarm_playing = false;
bool alarm_stopped = false;

const int* freq = axelf_freq;
const int* per = axelf_per;
int next_note = 0;

void play_next_note();
Timeout next_note_timeout;

void start_alarm(){
    disp.alarm_on = 1;
    disp.backlightOn(true); //Set backlight to permanently on
    alarm_playing = true;
    next_note = 0;
    next_note_timeout.attach(&play_next_note, 0.01);
}

void stop_alarm(){
    next_alarm = 0;
    alarm_playing = false;
    disp.alarm_on = 0;
    sound = 0.0f;
    wifi.printf("DELETE " 
                "/alarm/delete/nearest/58362c0bd0d41f4f91240f29 "
                "HTTP/1.1\r\n"
                "Host: 10.1.8.202:8080\r\n\r\n");
    disp.backlightOn(); //Set backlight to normal again
}

//TODO: won't work if melody contains -1 at the beginning, it has to have at least one note
void play_next_note(){
    if (!alarm_playing)
        return;
    
    const float bpm = 120.0f; //TODO: it's not actually tempo, figure out how to do this
    const float base_period = 0.25f;
    const float base_time = bpm / 60.0f;

    if (per[next_note] <= 0)
        next_note = 0;

    if (freq[next_note] != 0) {
        sound.period(base_period/freq[next_note]);
        sound = 0.5f;
    }
    else {
        sound = 0.0f;
    }
    
    next_note++;
    next_note_timeout.attach(&play_next_note, base_time/per[next_note-1]);    
}

int main() {
    wifi.baud(115200); 
    wifi.attach(&wifiCallback);
    //Initialization
    disp.backlightOn();
    button.rise(&userButtonPress);
    button.fall(&userButtonRelease);
    
    pc.printf("Waiting for time\r\n");
    
    lcd.locate(0,0); //Put in top row
    lcd.printf("Synchronizacja..");
    
    std::string time_string = httpGETWithRetry("GET " 
                "/time/current "
                "HTTP/1.1\r\n"
                "Host: 10.4.8.136:8080\r\n\r\n", 5.0, 5);
    
    //pc.printf("Get time returned >>%s<< %d\r\n", time_string.c_str());
    
    if (time_string == ""){
        lcd.locate(0,1); //Put in top row
        lcd.printf("Blad synchroniz.");
        wait(1);
        set_time(1256729737);  //DEBUG: Set RTC time to Wed, 28 Oct 2009 11:35:37
    }
    else {
        set_time(atoi(time_string.c_str()));
    }
    
    initRadio(6, NRF24L01P_TX_PWR_ZERO_DB, NRF24L01P_DATARATE_250_KBPS);
    
    while (1){
        //pc.printf("ok %f\r\n",light_sensor.read());
        
        //Handling button presses
        if (userButtonPressed) {
            userButtonPressed = 0;
            userButtonTimer.reset();
            userButtonTimer.start();
        }
        
        if (userButtonReleased) {
            userButtonReleased = 0;
            userButtonTimer.stop();
            if (userButtonTimer.read_ms() > userButtonLongPress){
                pc.printf("Long press\r\n");
                if (alarm_playing){
                    stop_alarm();
                }
                else {
                    //Force synchronization
                    next_sync = time(NULL);
                }
            }
            else {
                pc.printf("Short press\r\n");
                disp.backlightOn();
            }  
        }
        
        //Handling backlight
        if (backlightTimedOut){
            backlightTimedOut = 0;
            disp.backlightOff();
        }
        
        if (time(NULL) >= next_light){
            lightSensor();
        }
        
        //Synchronize with server
        if (time(NULL) >= next_sync){
            disp.sync_in_progress = 1;
            disp.update();
            syncFunction();
            disp.sync_in_progress = 0;
            disp.update();
        }
        
        //Check if alarm should be played
        if (next_alarm != 0 && !alarm_playing){
            if (time(NULL) >= next_alarm-(15*60) ){ //TODO: Hardcoded to 15 minutes before set time
            pc.printf("alarm1\r\n");
                if (movement_detected || time(NULL) >= next_alarm){
                    start_alarm();
                }
            }
        }
        
        //Try to receive from radio
        radio_recv();
        
        //Updating display
        disp.update();
        
        wait_ms(100);
    };
}



