#include "mbed.h"
#include "datos.h"

#define longitudTrama 500
#define frecuencia_muestreo 1000 // añadido por nosotros, 1000 muestreos/segundo

Timer timer;
float resultado;
int tiempo;

struct estructuraMedidas {
    float vrms;
    float irms;
    float potenciaActiva;
    float potenciaReactiva;
    float potenciaAparente;
    float energiaConsumida;
    float factorDePotencia;
};

float calcularRMS(int16_t *datos, int longitud);

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas);


int main()
{

    timer.reset();
    timer.start();
    resultado=calcularRMS(datos, longitudTrama);
    timer.stop();
    printf("****El valor Vrms es %f calculado en %d us ****\n",resultado,timer.read_us());

    estructuraMedidas medidas;
    medidas.energiaConsumida=0;

    timer.reset();
    timer.start();
    calcularDatos(datosV,datosI,longitudTrama,&medidas);
    timer.stop();
    printf("**** Datos calculados en %d us ****\n",timer.read_us());
    printf("**** El valor Vrms es %f ****\n",medidas.vrms);
    printf("**** El valor Irms es %f ****\n",medidas.irms);
    printf("**** La potencia activa es %f ****\n",medidas.potenciaActiva);
    printf("**** La potencia reactiva es %f ****\n",medidas.potenciaReactiva);
    printf("**** La potencia aparente es %f ****\n",medidas.potenciaAparente);
    printf("**** La energia consumida es %f ****\n",medidas.energiaConsumida);
    printf("**** El factor de potencia es es %f ****\n",medidas.factorDePotencia);

}

float calcularRMS(int16_t *datos, int longitud)
{
    float constante=0.1007080078125e-3;  //6.6/(2^16));
    int64_t sumatorio=0; // añadido
    for(int i=0; i<longitud; i++) {      // bucle for añadido
        sumatorio = sumatorio+(datos[i]*datos[i]);
    }

    return constante*sqrt(((float)sumatorio)/longitud); // para calcular Vrms

}

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas)
{
    //(*medidas).POTENCA // PARA ACCEDER A LA POTENCIA CON EL PUNTERO
    float constante = 0.1007080078125e-3; // (6.6/2^16)
    float constanteP_ac = 1.014210283756256103515625e-8;  // (6.6/2^16)^2
    int64_t sumatorioV = 0;
    int64_t sumatorioI = 0;
    int64_t sumatorioP_ac = 0;

    for(int i=0; i<longitud; i++) {
        sumatorioV = sumatorioV+(datosV[i]*datosV[i]);
        sumatorioI = sumatorioI+(datosI[i]*datosI[i]);
        sumatorioP_ac = sumatorioP_ac+datosV[i]*datosI[i];

    }

    medidas->vrms = constante*sqrt(((float)sumatorioV)/longitud) ;
    medidas->irms = constante*sqrt(((float)sumatorioI)/longitud); // para calcular Irms
    medidas->potenciaActiva = constanteP_ac*((float)sumatorioP_ac)/longitud;
    medidas->potenciaAparente = (medidas->vrms)*(medidas->irms);
    medidas->potenciaReactiva = sqrt((medidas->potenciaAparente)*(medidas->potenciaAparente)-(medidas->potenciaActiva)*(medidas->potenciaActiva));
    medidas->energiaConsumida = (medidas->potenciaActiva)/frecuencia_muestreo;
    medidas->factorDePotencia = (medidas->potenciaActiva)/(medidas->potenciaAparente);


}

