/****************************************************
* dSPACEとイーサネットで通信_センサ値を送信(16bit)_forDS1007
* 分布触覚センサ(8x32)forJAKSをマルチプレクサで読み取り_UDP送信
* 作成日：2020/11/19
* 作成者：鈴木陽介
****************************************************/

#include "mbed.h"               // mbedヘッダファイル
#include "Serial.h"             // シリアル通信用のヘッダファイル
#include "EthernetInterface.h"  // イーサネット通信設定用のヘッダファイル

//#define dSPACE_UDP              // Ethernetの接続先設定，宣言で制御器，コメントアウトでPC設定
#define UDP_DATA_SIZE (512)      // 制御器に送信するバイト数

// LPC1768 PIN設定 //////////////////////////////////////////////////////////

// マルチプレクサ・デマルチプレクサ制御
DigitalOut c0(p5);
DigitalOut c1(p6);
DigitalOut c2(p7);
DigitalOut c3(p8);
DigitalOut c4(p9);
DigitalOut c5(p10);
DigitalOut c6(p11);
DigitalOut c7(p12);
DigitalOut c8(p21);
DigitalOut c9(p22);
DigitalOut c10(p23);
DigitalOut c11(p24);
DigitalOut c12(p25);
DigitalOut c13(p26);
DigitalOut c14(p27);
DigitalOut c15(p28);
DigitalOut dr0(p13);
DigitalOut dr1(p14);
DigitalOut dr2(p15);
DigitalOut dr3(p16);

// 信号アナログ入力
AnalogIn sig1(p20);
AnalogIn sig2(p19);

// スイッチ入力（割り込み）
InterruptIn sw1(p18);

// tx, rx, PCとのシリアル通信 
Serial pc(USBTX, USBRX);
    
DigitalOut led1(LED1);          // 制御周期チェック用LED
DigitalOut led2(LED2);          // 以下,他のLEDを完全消灯するために設定（設定しないとわずかに光って気持ち悪い）
DigitalOut led3(LED3);
DigitalOut led4(LED4);



// 変数定義
int i,j = 0;
uint16_t dist1[8][32];
uint16_t dist2[8][32];
uint8_t data1[256];
uint8_t data2[256];
bool f_bs = 0;              //背景差分フラグ

// タイマ割り込み設定
Ticker myTimer;                 // タイマ割込み宣言,タイマ割り込みしないがこれがないと動かない

/*** 以下、サーバ → 制御器 or PC                                              ***
**** ホスト → マイコンとする                                                  ***
**** ※マイコン,制御器どちらともサーバ，ホストになれますが,混乱のないように区別します ***/

// サーバ側（制御器,PC）のアドレスとポート設定
#ifdef dSPACE_UDP
    const char* ECHO_SERVER_ADDRESS = "192.168.11.222";   // 制御器のIPアドレス
#else
    const char* ECHO_SERVER_ADDRESS = "192.168.0.197";  // マイノートPCのIPアドレス
#endif    
const int ECHO_SERVER_PORT = 5007;                      // サーバ側のポート設定
 
// マイコン側のアドレスとポート
#ifdef dSPACE_UDP
    const char * IPaddress = "192.168.11.224";    // 制御器との通信用IPアドレス
#else
    const char * IPaddress = "192.168.0.224";   // マイノートPCとの通信用 "
#endif
 
const char * NetworkMask = "255.255.255.0";       // ネットワークマスクのアドレス
const char * Gateway = "0.0.0.0";               // デフォルトゲートウェイ
const int MY_PORT = 5008;                       // ホスト側のポート設定




////// 割り込み関数 ///////

// sw1（背景差分切替）
void flip1(){
    f_bs = !f_bs;
}

/////////////////////////


////// メイン文 ////////////////////////////////////////////////////////
int main() {
    ////// 変数の宣言　//////////////////////////////////////////////////
    int i,j = 0;
    char udp_txData[UDP_DATA_SIZE];         // Ethernet通信、送信用バッファ
    bool bs_ok = 0;             //背景データ有無判定
    uint16_t bs_dist1[8][32];   //背景データ１
    uint16_t bs_dist2[8][32];   //背景データ２

    // マイコンLED設定
    led1 = 0;       // 全LEDをOFF
    led2 = 0;
    led3 = 0;
    led4 = 0;
    
    // イーサネット通信設定
    EthernetInterface eth;                                          // イーサネットオブジェクト生成
    int res2 = eth.init(IPaddress, NetworkMask, Gateway);           // 固定IPアドレスの設定
    //printf("\neth.init() static -> %d\n", res2);
    int res3 = eth.connect(15000);                                  // ケーブルの先に接続相手がいるか確認している？（無接続時にエラー
    pc.printf("%d\n", res3);
    //printf("\neth.connect() -> %d\n", res3);
    //printf("\nServer IP Address is %s\n", eth.getIPAddress());      // マイコンのIPアドレス表示
    UDPSocket sock;                                                 // UDPソケット作成
    int res31 = sock.bind(MY_PORT);                                 // マイコン側ポート設定
    //printf("\sock_bind() -> %d\n", res31);
    Endpoint echo_server;                                           // サーバ側オブジェクト生成
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT); // サーバ側のIPアドレスとポートを指定
    
    wait(1.0);
    
    //初期化
    for(i=0;i<256;i++){
        data1[i] = 0;
        data2[i] = 0;
    }
    
    //// メインループ /////////////////////////////////////////////////////////////////////////////////////
    while(1){
            
        // LED1 ON
        led1 = 1;
        
        //データ計測
        for(i=0;i<16;i++){
            
            if(i==0)    c0 = 1;
            else        c0 = 0;
            if(i==1)    c1 = 1;
            else        c1 = 0;
            if(i==2)    c2 = 1;
            else        c2 = 0;
            if(i==3)    c3 = 1;
            else        c3 = 0;
            if(i==4)    c4 = 1;
            else        c4 = 0;
            if(i==5)    c5 = 1;
            else        c5 = 0;
            if(i==6)    c6 = 1;
            else        c6 = 0;
            if(i==7)    c7 = 1;
            else        c7 = 0;
            if(i==8)    c8 = 1;
            else        c8 = 0;
            if(i==9)    c9 = 1;
            else        c9 = 0;
            if(i==10)   c10 = 1;
            else        c10 = 0;
            if(i==11)   c11 = 1;
            else        c11 = 0;
            if(i==12)   c12 = 1;
            else        c12 = 0;
            if(i==13)   c13 = 1;
            else        c13 = 0;
            if(i==14)   c14 = 1;
            else        c14 = 0;
            if(i==15)   c15 = 1;
            else        c15 = 0;
            
            for(j=0;j<16;j++){
       
                dr0 = (j & 0b0001);
                dr1 = (j & 0b0010) >> 1;
                dr2 = (j & 0b0100) >> 2;
                dr3 = (j & 0b1000) >> 3;
                
                wait_us(1);
                
                if(i<8){
                    dist1[i][j] = sig1.read_u16();
                    dist2[i][j] = sig2.read_u16();
                }
                else{
                    dist1[i-8][j+16] = sig1.read_u16();
                    dist2[i-8][j+16] = sig2.read_u16();
                }
                
            }
        }
        
        // 背景差分スイッチを判定
        sw1.rise(&flip1);
        //sw2.rise(&flip1);
        
        // 背景差分フラグ判定
        if(f_bs){
            // LED2 ON
            led2 = 1;
            
            // 背景データが無い場合は先にデータを取得
            if(!bs_ok){
                for(i=0;i<8;i++){
                    for(j=0;j<32;j++){
                        bs_dist1[i][j] = dist1[i][j];
                        bs_dist2[i][j] = dist2[i][j];
                    }
                }
                bs_ok = true;
            }
            
            // 背景差分実行
            for(i=0;i<8;i++){
                for(j=0;j<32;j++){
                    if(dist1[i][j] > bs_dist1[i][j])
                        dist1[i][j] -= bs_dist1[i][j];
                    else
                        dist1[i][j] = 0;
                    if(dist2[i][j] > bs_dist2[i][j])
                        dist2[i][j] -= bs_dist2[i][j];
                    else
                        dist2[i][j] = 0;
                }
            }
        }
        else{
            // LED2 ON
            led2 = 0;
            
            // 背景差分データ有無をリセット
            bs_ok = false;
        }



        for(i=0;i<8;i++){
            for(j=0;j<32;j++){
                //XY反転なし
                data1[i*32+j] = dist1[i][j] >> 6;
                data2[i*32+j] = dist2[i][j] >> 6;
            }
        }


        // LED OFF
        led1 = 0;
    
        // udp送信用ビット演算
        for(i=0; i<256; i++){
            udp_txData[i] = data1[i];
            udp_txData[i+256] = data2[i];
        }
        
        //wait(1);
        /*
        led1 = 1;
        wait_us(10);
        led1 = 0;
        */
        
        sock.sendTo(echo_server, udp_txData, UDP_DATA_SIZE);    // Ethernet送信, sock.sendTo(サーバ, 送信文字データ, 送信文字数)
        
        //led1 = !led1;   // 通信確認用LED，LED1が光る
        
        /*
        led1 = 1;
        wait_us(5);
        led1 = 0;
        */    
    }
}

