int setting_press()
{
    int x = readX();
    int y = readY();
    if (touching == 1) {
        if (x > 0 && x < 50 && y > 0 & y < 100) { // side button 1 (set)
            //set desired state to 1
            return 1;
        } else if (x > 0 && x < 50 && y > 100 & y < 200) { //side button 2 (cancel)
            //set desired state to 2
            return 2;
        } else if (x > 0 && x < 50 && y > 200 && y < 240) { // button home
            //set desired state to 0
            return 0;
        } else if (x > 50 && x < 185 && y > 0 && y < 100) { // Alarm Hour
            return 11;
        } else if (x > 185 && x < 320 && y >  0 && y < 100) { // Alarm Min
            return 12;
        } else if (x > 50 && x < 185 && y >  100 && y < 200) { //Time Hour
            return 13;
        } else if (x > 185 && x < 320 && y >  100 && y < 200) { //Time Min
            return 14;
        } else if (x > 50 && x < 140 && y >  200 && y < 300) { //Time Date
            return 15;
        } else if (x > 140 && x < 230 && y >  200 && y < 300) { //Time Month
            return 16;
        } else if (x > 230 && x < 320 && y >  200 && y < 300) { //Time Year
            return 17;
        }
    }
    return -1;
}

void drawsettingback() //Navigation Buttons
{
    TFT.cls();
    TFT.fillrect(0,0,50,100,Blue);        //set alarm button
    TFT.fillrect(0,100,50,200,White);   //set time button


    TFT.rect(0,0,50,100,Blue);      //outlines
    TFT.rect(0,100,50,200,White);   //outlines
    TFT.rect(0,200,50,240,White);   //outlines

    //alarm/time colons
    int tx,ty = 0;
    ty = 50;
    tx = 185;
    TFT.fillcircle(tx, ty - 10, 2, White);
    TFT.fillcircle(tx, ty + 10, 2, White);
    ty = 150;
    TFT.fillcircle(tx, ty - 10, 2, White);
    TFT.fillcircle(tx, ty + 10, 2, White);
    TFT.rect(50,0,320,100,Blue);  //set alarm box
    TFT.rect(50,100,320,200,White); //set time box
    TFT.rect(50,200,320,240,White); //set date box

    TFT.set_font((unsigned char*) Arial12x12); //set alarm title
    TFT.locate(157,8);
    TFT.printf("Set Alarm");
    TFT.set_font((unsigned char*) Arial12x12); //set time title
    TFT.locate(157,108);
    TFT.printf("Set Time");
    //Cancel button
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(62,20);
    TFT.set_orientation(0);
    TFT.background(White);
    TFT.foreground(Black);
    TFT.printf("Cancel");
    TFT.background(Black);
    TFT.foreground(White);
    TFT.set_orientation(1);

    //Set New button (used to set new alarm/time/date)

    TFT.locate(161,20);
    TFT.set_orientation(0);
    TFT.background(Blue);
    TFT.printf("Set New");
    TFT.background(Black);
    TFT.set_orientation(1);
    //home button
    TFT.locate(5,217);
    TFT.foreground(Blue);
    TFT.printf("Home");
    TFT.foreground(White);
}

void drawsettinganimate(int a_h, int a_m, int t_h, int t_m, int t_d, int t_mo, int t_y) //draw alarm, time, date
{



    TFT.set_font((unsigned char*) Arial28x28); //set alarm hour

    TFT.locate(90,40);
    TFT.printf("%d",a_h); // print Alarm hour
    TFT.locate(230,40);
    TFT.printf("%d",a_m);//Alarm_Min
    TFT.set_font((unsigned char*) Arial28x28); //set time hour
    TFT.locate(90,140);
    TFT.printf("%d",t_h); // Time_hour
    TFT.locate(230,140);
    TFT.printf("%d",t_m);//Time Min
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(60,215);
    TFT.printf("%d",t_d); //print date
    TFT.locate(150,215);
    TFT.printf("%d",t_mo); //print month
    TFT.locate(265,215);
    TFT.printf("%d",t_y); //print year




}
void settings()
{
    int a_h, a_m, t_h, t_m,t_d,t_mo,t_y = 0;
    a_h = tm_a_hr;
    a_m = tm_a_min;
    t_h = tm_c.hour;
    t_m = tm_c.min;
    t_d = tm_c.date;
    t_mo = tm_c.mon;
    t_y = tm_c.year;
    int multiplier = 8;
    int o_setting = 11;
    drawsettingback();
    int option = 0;
    float tsi_current, tsi_last;
    while (true){
        drawsettinganimate(a_h, a_m,t_h,t_m,t_d,t_mo,t_y);
        option = setting_press();
        int newval = 0;
        if (option == 0 || option == 2) {
            pc.printf("exiting");
            break;
        }
        switch (option) {
            case (11):
                o_setting = 11;
                break; //Alarm Hour
            case (12):
                o_setting = 12;
                break; //Alarm Min
            case (13):
                o_setting = 13;
                break; //
            case (14):
                o_setting = 14;
                break; //
            case (15):
                o_setting = 15;
                break; //
            case (16):
                o_setting = 16;
                break; //
            case (17):
                o_setting = 17;
                break; //
        }
        
        tsi_current = tsi.readPercentage();
        float change = 0;
    
        if (tsi_current != 0 && tsi_last != 0) {change = tsi_current - tsi_last;}
        else {change = 0;}
        tsi_last = tsi_current;
        int delta = change * multiplier;
        pc.printf("change in slider:%f, change in total:%f",change,delta);
        switch (o_setting) {
            case(11):
                
                newval = a_h + delta ;
                while (newval < 0) {
                    newval += 24;
                }
                a_h = newval % 25;
                TFT.fillrect(70, 40, 150, 80, Black);
                TFT.set_font((unsigned char*) Arial28x28); //set alarm hour
                TFT.locate(90,40);
                TFT.foreground(Red);
                TFT.printf("%d", a_h);//Alarm_Hour
                break;
            case(12):
                newval = a_m + delta ;
                while (newval < 0) {
                    newval += 60;
                }
                a_m = newval % 60;
                TFT.fillrect(200, 40, 300, 80, Black);
                TFT.set_font((unsigned char*) Arial28x28); //set alarm min
                TFT.locate(230,40);
                TFT.foreground(Red);
                TFT.printf("%d", a_m);//Alarm_Min
                break;
            case(13):   //set time hour
                newval = t_h + delta ;
                if (newval < 0) newval += 24;
                t_h = newval % 24;
                TFT.fillrect(90, 140, 150, 180, Black);
                TFT.set_font((unsigned char*) Arial28x28);
                TFT.foreground(Red);
                TFT.locate(90,140);
                TFT.printf("%d",t_h); // Time_hour
                break;
            case(14): //set time min
                newval = t_m + delta ;
                if (newval < 0) newval += 60;
                t_m = newval % 60;
                TFT.fillrect(200, 140, 300, 180, Black);
                TFT.set_font((unsigned char*) Arial28x28);
                TFT.foreground(Red);
                TFT.locate(230,140);
                TFT.printf("%d",t_m);//Time Min
                break;
            case(15): // set time date
                newval = t_d + delta ;
                if (newval < 1) newval += 31;
                t_d = newval % 32;
                TFT.fillrect(55, 202, 148, 238, Black);
                TFT.foreground(Red);
                TFT.set_font((unsigned char*) Arial12x12);
                TFT.locate(60,215);
                TFT.printf("%d",t_d); //print date
                break;
            case(16): // set time month
                newval = t_mo + delta ;
                if (newval < 1) newval += 12;
                t_mo = newval % 13 ;
                
                TFT.fillrect(148, 202, 263, 238, Black);
                TFT.foreground(Red);
                TFT.set_font((unsigned char*) Arial12x12);
                TFT.locate(150,215);
                TFT.printf("%d",t_mo); //print month
                break;
            case(17): //set time year
                newval = t_y + delta ;
                if (newval > 1970 && newval < 2700) t_y = newval;
                TFT.fillrect(263, 202, 310, 238, Black);
                TFT.foreground(Red);
                TFT.set_font((unsigned char*) Arial12x12);
                TFT.locate(265,215);
                TFT.printf("%d",t_y); //print year
                break;
        }
        TFT.foreground(White);
        if (option == 1) {
            tm_a_hr = a_h;
            tm_a_min = a_m;
            tm_c.min = t_m;
            tm_c.hour = t_h;
            tm_c.date = t_d;
            tm_c.mon = t_mo;
            tm_c.year = t_y;
            tm_c.wday = date2day(tm_c.date, tm_c.mon, tm_c.year);
            while (!rtc.setTime(tm_c, true, false)) { //set the Time in RTC Param : ( Time container, Start Clock, Twelve Hour Clock)
        //       n++;
             }
           // pc.printf("Tried to write %d times\n\r",n);
            break;
        }
    }
    f_state = 1;
}