int digital_clock_press(){
    int x = readX(); // read x location 
    int y = readY(); // read y location
    if (touching == 1) {
       
        if (x > 0 && x < 50 && y > 0 & y < 50) // side button 1 (clock state)
        {
            //set desired state to 1 
            return 1;
        }
        else if (x > 0 && x < 50 && y > 50 & y < 100) //side button 2 (change time)
        {
            //set desired state to 2 
            return 2;
        }
        else if (x > 0 && x < 50 && y > 100 && y < 150) // side button 3 
        {
            //set desired state to 3
            return 3;
        }
        else if (x > 0 && x < 50 && y > 150 && y < 200) // side button 4 
        {
            //set desired state to 4
            f_cycle = !f_cycle;
            f_cycle_secs = tm_c.sec;
            //wait(0.5);
           // return 4;
            
        }else if (x > 0 && x < 50 && y > 200 && y < 240) // button home
        {
            //set desired state to 0
            return 0;
        }
        else if (x > 140 && x < 320 && y >  100 && y < 200) // alarm button on or off
        {
            //set desired state to 5
            f_alarm = !(f_alarm);
            f_alarm_sound = false;  // flag for the alarm sound
            return -1;
        }
    }
    return -1;
}
        
    


void runclock() // getting time from the clock
{
    DigitalOut gnd(PTA4) ; // initiating buzzer
    PwmOut buzzer(PTA5);
    float frequency[]={758, 758, 758, 955, 758, 638, 1276, 955, 1276, 1517, 1136, 1012, 1073, 1136, 1276, 758, 638, 568, 716, 638, 758, 955, 851, 1012, 955};
    //frequency array
    float beat[]={0.2, 0.4, 0.4, 0.2, 0.4, 0.8, 0.8, 0.6, 0.6, 0.6, 0.4, 0.4, 0.2, 0.4, 0.26, 0.26, 0.26, 0.4, 0.2, 0.4, 0.4, 0.2, 0.2, 0.2, 0.4};
    //time intervals
    int i =0;
    int last = 0;
    draw_state(1);
    while (f_state == 1){
        read_time();
        TFT.set_font((unsigned char*) Arial24x23); //coverup
        if (tm_c.sec == 0){      //getting seconds and printing
            TFT.locate(250,40);
            TFT.printf("  ");
            if (tm_c.min == 0){  //getting minutes and printing
                TFT.locate(160,40);
                printf("  ");
                if (tm_c.hour == 0)  //getting hours and printing
                {
                    TFT.locate(70,40);
                    printf("  ");
                }
            }
        }
            
                if(f_alarm && tm_c.hour == tm_a_hr && tm_c.min == tm_a_min && tm_c.sec < 3){
                    f_alarm_sound = true; //alarm buzzes
                }
                
      
                if (f_alarm_sound) 
                {
                    i = i % 26;
                    i++ ;
                    buzzer.period(1/(frequency[i])); // set PWM period
                    buzzer=0.5;
                    wait(0.1*beat[i]);
                //
                //hold for beat period ;
                } else buzzer = 0;
        TFT.locate(70,40);
        TFT.printf("%d",tm_c.hour);
        TFT.locate(160,40);
        TFT.printf("%d",tm_c.min);
        TFT.locate(250,40);
        TFT.printf("%d",tm_c.sec);
        TFT.locate(60,140);
        TFT.set_font((unsigned char*) Arial12x12);
        if (last != tm_c.wday) printf("        ");
        last = tm_c.wday;
        TFT.locate(60,140);
        TFT.printf("%s",rtc.weekdayToString(tm_c.wday + 1));
        TFT.set_font((unsigned char*) Arial24x23);
        if (f_alarm) {
            TFT.locate(160,140);
            TFT.printf("%d",tm_a_hr);
            TFT.locate(250,140);    
            TFT.printf("%d",tm_a_min);    
        }
        else
        {
            TFT.locate(160,140);
            TFT.printf("   ");
           TFT.locate(250,140);    
           TFT.printf("   ");   
        }
        TFT.locate(70,210);
        TFT.printf("%d / %d / %d", tm_c.date, tm_c.mon, tm_c.year);
        wait(0.2);
       /* TFT.locate(160,210);    
        TFT.printf("%d",tm_c.mon);    
        TFT.locate(220,210);    
        TFT.printf("%d",tm_c.year);     */
        if (f_cycle){
            if ((f_cycle_secs + f_cycle_wait) == tm_c.sec){
            f_state = 2;
            f_cycle_secs = tm_c.sec;
            }
        }
        switch (digital_clock_press()){
            case (-1): break;
            case (0): f_state = 1; break;
            case (1): f_state = 2; break;
            case (2): f_state = 3; break;
            case (3): f_state = 4; break;
            case (4): f_state = 5; break;
        }
    }
}