#include "mbed.h"
#include "C12832.h"
#include "SWSPI.h"
#include <cmath>

SWSPI spi(PC_4,PC_12,PA_13); // MOSI"bidon" / MISO /CLK

C12832 lcd(D11, D13, D12, D7, D10);

DigitalOut CS(PA_14);


InterruptIn index(PA_15);

double cpt_fall=0;

float distance=0,cpt_rise=0,compteur_index=0;

short cpt=0;

long x=0,x1=0,pas,RAZ = 0,pos_finale=0, pos_initiale=0;



void pressed()
{
    if (x >= 3000) {
        cpt_rise++;
    }
    if (x <= 1000) {
        cpt_rise--;
    }

}

void released()
{
    cpt_fall++;
}

int main ()
{
    spi.format(18,3); //////////////////////////////////////
    spi.frequency(100000);          // Initialisation SPI software
    CS=1;
    lcd.cls();/////////////////////////////////////////////

    wait_ms(100);///////////////////////////////////////////
    CS=0;
    wait_us(50);

    pos_initiale=spi.write(0);       //Determination pos_initialetion initiale

    wait_us(50);
    CS=1;
    pos_initiale = pos_initiale>>5;/////////////////////////////////////////////

    pos_finale=x-pos_initiale;

    //pas = (abs(x-x1))%4095;
    distance=((pos_finale*(0.000488)+(cpt_rise*2)));

    while(1) {
        pos_finale=x-pos_initiale;

        index.fall(&pressed);
        index.rise(&released);

        wait_ms(100);
        CS=0;
        wait_us(50);

        x1=x;
        x=spi.write(0);

        //pas = (abs(x-x1))%4095;
        distance=((pos_finale*(0.000488)+(cpt_rise*2))); // Calcul de la distance parcouru depuis le 0 en mm

        wait_us(50);
        CS=1;
        x = x>>5;

        lcd.locate(0,3);
        lcd.printf("DIST= %.5f",distance);
        lcd.locate(0,14);
        lcd.printf("POS= %5ld", x);

        /*
        lcd.locate(0,3);
        lcd.printf("pos_initiale= %ld",pos_initiale);
        lcd.locate(0,14);
        lcd.printf("POS= %5ld", x);
        */
    }
}