/* mbed simple Servo controller
 * Copyright (c) 2019, marcel.bernet@ch-open.ch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "Servo.h"



Servo::Servo(PinName pin) : _pwm(pin)
{
    _pwm.period_ms(20);
    write(0.5);
}

void Servo::write(float percent)
{
    _p = percent;
    float p = percent * (SERVO_MAX-SERVO_MIN) + SERVO_MIN;
    p = (p < SERVO_MIN) ? SERVO_MIN : p;
    p = (p > SERVO_MAX) ? SERVO_MAX : p;
    _pwm.pulsewidth_us( (int) p );
}

float Servo::read()
{
    return _p;
}

Servo& Servo::operator= (float percent)
{
    write(percent);
    return *this;
}

Servo& Servo::operator= (Servo& rhs)
{
    write(rhs.read());
    return *this;
}

Servo::operator float()
{
    return read();
}



