/* 
 * Copyright (c) 2016 Delta Electronics(Japan), Inc
 *
 */
#include "us_ticker_rtc.h"
#include "us_ticker_api.h"

static time_t  initTime = 0;
static uint32_t init_us_tick = 0;

void us_ticker_rtc_init(void)
{
    initTime = 0;
    init_us_tick = us_ticker_read();
}
    
void us_ticker_rtc_free(void)
{
}

int us_ticker_rtc_isenabled(void)
{
    return 1;
}

time_t us_ticker_rtc_read(void)
{
    uint32_t now_us_tick = us_ticker_read();
    
    if (now_us_tick > init_us_tick) {
        return initTime + ((now_us_tick - init_us_tick) / 1000000);
    } else {
        return initTime + ((0xFFFFFFFF - init_us_tick + now_us_tick + 1) / 1000000);
    }
}

void us_ticker_rtc_write(time_t t)
{
    initTime = t;
    init_us_tick = us_ticker_read();
}

