from coapthon.server.coap import CoAP
from coapthon.resources.resource import Resource
from threading import Thread


class DatabaseResource(Resource):
    def __init__(self, table, connector, name='DatabaseResource', coap_server=None):
        super(DatabaseResource, self).__init__(name, coap_server, visible=True, observable=True, allow_children=True)
        self.table = table
        self.connector = connector
        self.payload = 'GET is not implemented'

    def render_GET(self, request):
        return self

    def render_POST(self, request):
        ret = self.connector.write(self.table, request.payload)
        if ret:
            print 'CoAP server error: ' + ret
        return self

    def render_PUT(self, request):
        return self

    def render_DELETE(self, request):
        return self


class CoAPServer(CoAP, Thread):
    def __init__(self, host, port, routes, connector):
        Thread.__init__(self)
        CoAP.__init__(self, (host, port))
        for t in routes:
            self.add_resource(t + '/', DatabaseResource(t, connector))
        print 'CoAP server starts on ' + host + ':' + str(port)
        print self.root.dump()

    def run(self):
        self.listen(10)